<?php
	if (session_status() == PHP_SESSION_NONE)
	{
		session_start();
	}
	function jeSuisConnecte()
	{
		return (!empty($_SESSION['utilisateur']) && $_SESSION['utilisateur']['connecte'] === true)? true: false;
	}
	function jeSuisPasConnecte()
	{
		return !jeSuisConnecte();
	}
	function jeSuisAdmin()
	{
		return (jeSuisConnecte() && $_SESSION['utilisateur']['role'] === 1)? true: false;
	}
	function jeSuisPadAdmin()
	{
		return !jeSuisAdmin();
	}
	function jeSuisRedacteur()
	{
		return (jeSuisConnecte() && $_SESSION['utilisateur']['role'] === 2)? true: false;
	}
	function jeSuisPasRedacteur()
	{
		return !jeSuisRedacteur();
	}
	
	function jeFaisPartieDuStaff()
	{
		return (jeSuisAdmin() || jeSuisRedacteur())?true: false;
	}
	function jeFaisPasPartieDuStaff()
	{
		return !jeFaisPartieDuStaff();
	}
	
	function ilEstAdmin($perId)
	{
		$resultat = false;
		require('fonctionBdd.php');
		$requete = 'SELECT `perRole` FROM `personnes` WHERE `perId` = '. intval($perId);
		$stmt = $bdd->prepare($requete);
		$stmt->execute();
		if($row = $stmt->fetch(PDO::FETCH_OBJ))
		{
			$resultat = ($row->perRole === 1)?true: false;
		}
		return $resultat;
	}
	function ilEstPasAdmin($perId)
	{
		return (ilEstAdmin($perId))?false: true;
	}
	function cMonProfil($prodilId)
	{
		return (jeSuisConnecte() && $prodilId === $_SESSION['utilisateur']['id'])? true: false;
	}
	function cPasMonProfil($prodilId)
	{
		return !cMonProfil($prodilId);
	}
	function ilEstRedacteur($perId)
	{
		$resultat = false;
		require('fonctionBdd.php');
		$requete = 'SELECT `perRole` FROM `personnes` WHERE `perId` = '. intval($perId);
		$stmt = $bdd->prepare($requete);
		if($stmt->execute()) { if($row = $stmt->fetch(PDO::FETCH_OBJ)) { $resultat = ($row->perRole === 2)?true: false; } }
		else
		{
			$codeErreur = $stmt->errorInfo();
			$resultat = 'Une erreur est survenue. Code erreur SQL: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2];
		}
		return $resultat;
	}
	function ilEstPasRedacteur($perId)
	{
		return (ilEstRedacteur($perId))? false: true;
	}
	function quelEstSonRole($perid)
	{
		$resultat = false;
		require('fonctionBdd.php');
		$requete = 'SELECT `perRole` FROM `personnes` WHERE `perId` = '. intval($perId);
		$stmt = $bdd->prepare($requete);
		if($stmt->execute())
		{
			if($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				switch($row->perRole)
				{
					case 1: $resultat = 'administrateur'; break;
					case 2: $resultat = 'redacteur'; break;
					default: $resultat = false; break;
				}
			}
		}
		else
		{
			$codeErreur = $stmt->errorInfo();
			$resultat = 'Une erreur est survenue. Code erreur SQL: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2];
		}
		return $resultat;
	}
	
	function accueillirStaff()
	{
		if(jeFaisPartieDuStaff())
		{
			$utilisateur = $_SESSION['utilisateur'];
			$salutation = (date('h', time())>18 && date('h', time())<3)?'Bonsoir ':'Bonjour ';
			$resultat = $salutation.'<a href="?moteur=editer&objet=personne;'.$utilisateur['id'].'">'.$utilisateur['nom'].' '.$utilisateur['prenom'].'</a><br />
			<br />
			Bienvenue sur l\'espace d\'administration de votre site web. C\'est ici que vous pourrez modifier vos contenus, vos thèmes, l\'architecture de votre site, les comptes d\'utilisateurs et envoyer vos lettres d\'information.<br />
			';
		}
		else
		{
			$resultat = 'Impossible de vous accueillir en tant que membre de l\'équipe d\'administration.<br />
			<a id="pagePrecedente"></a><br />
			<a href="?moteur=index">Site en acces public</a>
			<a href="?moteur=article&objet=1">Se connecter</a>';
		}
		return $resultat;
	}
	
	
	function quePuisJeFaire()
	{
		if(jeFaisPasPartieDuStaff())
		{
			$resultat = 'En tant que visiteur de ce site web vous pouvez lire les contenus qui s\'y trouvent';
		}
		else
		{
			$resultat = 'En tant que membre de l\'équipe d\'administration vous pouvez acceder à l\'espace d\'administration.';
			if(jeSuisAdmin())
			{
				$resultat .= '<br />De plus, vous avez le rôle d\'administrateur. Cela signifie que vous avez acces à toutes les fonctions du site web.';
			}
			elseif(jeSuisRedacteur())
			{
				$resultat .= '<br />De plus, vous avez le rôle deredacteur. Cela signifie que vous pouvez écrire et modifier des articles (sans pour autant pouvoir modifier leur statut <i>en ligne</i> ou <i>hors-ligne</i>).';
			}
		}
		return $resultat;
	}
	
	
	
?>