<?php

	function preparerTheme()
	{
		$nomParDefaut = 'Thème par defaut';
		$dossierParDefaut = 'defaut';
		$informationsParDefaut = 'Aucun thème n\'a été défini, le site utilise donc le thème par défaut.';
		$theme = array('nom'=>$nomParDefaut, 'dossier'=>$dossierParDefaut, 'informations'=>$informationsParDefaut);
		
		if(empty($_GET['theme']))
		{
			require('fonctionBdd.php');
			$requete = 'SELECT * FROM `themes` WHERE `theActivite` = 1
			LIMIT 1';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$theme = array('nom'=>$row->theNom, 'dossier'=>$row->theDossier,'informations'=>$row->theInformations);
			}
		}
		else
		{
			$theme = array(
			'nom' => 'Thème en prévisualisation',
			'dossier' => $_GET['theme'],
			'info' => 'Vous êtes en train de prévisualiser le thème dans le dossier '.$_GET['theme']	);
		}
		return $theme;
	}

	function chargerTheme($dossierTheme)
	{
		$url = 'style/theme/'. $dossierTheme .'/style.css';
		$defaut = 'style/theme/defaut/style.css';
		$url = (file_exists($url))? $url : $defaut ;
		echo '<link rel="stylesheet" type="text/css" href="'. $url .'" />';
	}
	
	function trouverDossierTheme($dossier)
	{
		$resultat = 'Impossible de trouver le repertoire de thème nommé '.$dossier;
		$url = 'style/theme/'.$dossier;
		$url2 = '../style/theme/'.$dossier;
		if(is_dir($url) || is_dir($url2))
		{
			$resultat = (file_exists($url.'/style.css') || file_exists($url2.'/style.css'))?true:'Le fichier style.css du thème est introuvable.';
		}
		return $resultat;
	}
	
	function activerTheme($id)
	{
		if(jeSuisAdmin())
		{
			$id = intval($id);
			require('fonctionBdd.php');
			$requete = 'SELECT * FROM `themes` WHERE `theId` = '.$id;
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$resultat = trouverDossierTheme($row->theDossier);
				if($resultat === true)
				{
					$requete = 'UPDATE `themes` SET `theActivite` = 0 WHERE `theActivite` = 1 ;
								UPDATE `themes` SET `theActivite` = 1 WHERE `theId` = '.$id.';';
					$stmt = $bdd->prepare($requete);
					$stmt->execute();
					$resultat = 'Le thème <b><i>'.$row->theNom.'</i></b> est désormais activé sur le site';
				}
			}
			else
			{
				$resultat = 'Le thème sélectionné n\'existe pas.';
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de suffisamment de droits pour gérer les thèmes du site.';
		}
		return $resultat;
	}
	
	function exporterTheme($id)
	{
		$id = intval($id);
		if(jeFaisPartieDuStaff())
		{
			$id = intval($id);
			require('fonctionBdd.php');
			$requete = 'SELECT * FROM `themes` WHERE `theId` = '.$id;
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$resultat = trouverDossierTheme($row->theDossier);
				if($resultat === true)
				{
					$repertoire = '../style/theme/'.$row->theDossier;
					$zip = new ZipArchive;
					$zip->open('../style/'.$row->theDossier.'.zip', ZipArchive::CREATE);
					$listeFichiers = scandir($repertoire);
					unset($listeFichiers[array_search('.', $listeFichiers)]);
					unset($listeFichiers[array_search('..', $listeFichiers)]);
					foreach($listeFichiers as $fichier)
					{
						$zip->addFile($repertoire.'/'.$fichier, $fichier);
					}
					$zip->addFromString('nom.txt', $row->theNom);
					$zip->addFromString('dossier.txt', $row->theDossier);
					$zip->addFromString('informations.txt', $row->theInformations);
    
					// Zip archive will be created only after closing object
					$zip->close();
					
					preparerCorbeille('style/'.$row->theDossier.'.zip');
					$resultat = '<a href="style/'.$row->theDossier.'.zip" target="_blank">Cliquez ici pour télécharger l\'archive</a>. Elle sera disponible au téléchargement pendant au moins 2 minutes.';
				}
			}
			else
			{
				$resultat = 'Le thème sélectionné n\'existe pas.';
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de suffisamment de droits pour gérer les thèmes du site.';
		}
		return $resultat;
	}
	
	function supprimerTheme($id)
	{
		if(jeSuisAdmin())
		{
			require('fonctionBdd.php');
			$requete = 'SELECT * FROM `themes` WHERE `theId` = '.intval($id);
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				if($row->theActivite == 0)
				{
					$resultat = trouverDossierTheme($row->theDossier);
					if($resultat === true)
					{
						$archive = exporterTheme($id);
						$url = 'style/theme/'.$row->theDossier;
						$cible = (is_dir('style/theme'))? $url : '../'.$url;
						clearDir($url);
						$requete = 'DELETE FROM `themes` WHERE `theId` = '.intval($id);
						$stmt = $bdd->prepare($requete);
						$stmt->execute();
						$resultat ='Le thème a totalement été effacé de votre site web. Une archive a été créer automatiquement pour vous permettre de revenir en arrière.<br />
						'.$archive;
					}
				}
				else
				{
					$resultat = 'Le thème <b><i>'.$row->theNom.'</i></b> est actuellement en cours d\'utilisation sur votre site. Il ne peut donc pas être supprimer.';
				}
			}
			else
			{
				$resultat = 'Le thèmes recherché n\'existe pas dans la base de donnée.';
			}
		}
		else
		{
			$resultat = '';
		}
		return $resultat;
	}
	
	function clearDir($dossier)
	{
		$ouverture=@opendir($dossier);
		if (!$ouverture) return;
		while($fichier=readdir($ouverture))
		{
			if ($fichier == '.' || $fichier == '..') continue;
				if (is_dir($dossier."/".$fichier)) {
					$r=clearDir($dossier."/".$fichier);
					if (!$r) return false;
				}
				else {
					$r=@unlink($dossier."/".$fichier);
					if (!$r) return false;
				}
		}
		closedir($ouverture);
		$r=@rmdir($dossier);
		if (!$r) return false;
		return true;
	}
	
	function ajouterTheme($nom, $dossier, $informations = null)
	{
		if(jeSuisAdmin())
		{
			if(is_null($infomrations))
			{
				$informations = 'Thème '.$nom.' Calypso télécharger le'.date('d/m/Y').' à '.date('h:i:s');
			}
			require('fonctionBdd.php');
			$requete = 'INSERT INTO `themes` (`theNom`, `theDossier`, `theInformations`) VALUES (:nom, :dossier, :informations);';
			$stmt = $bdd->prepare($requete);
			$stmt->bindParam(':nom', $nom, PDO::PARAM_STR);
			$stmt->bindParam(':dossier', $dossier, PDO::PARAM_STR);
			$stmt->bindParam(':informations', $informations, PDO::PARAM_STR);
			if($stmt->execute())
			{
				$nbrOperation = $stmt->rowCount();
				if($nbrOperation == 1)
				{
					$resultat = 'Le thème a été ajouté avec succes.';
				}
				elseif($nbrOperation > 1)
				{
					$resultat = $nbrOperation.' opérations ont été effectuées au lieu d\'une seule comme prévu. Verifiez qu\'aucun probème n\'est survenue.';
				}
				else
				{
					$resultat = 'Une erreur inconnue est survenue. Le thème n\'a pas été ajouté';
				}
			}
			else
			{
				$codeErreur = $stmt->errorInfo();
				$resultat = '<br /><fieldset>
					<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
					<p>'. $codeErreur[2] .'</p>
				</fieldset>';
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de suffisament de droits pour ajouter un thème';
		}
		return $resultat;
	}
	
	function feuillesPersonellesTheme($dossier = 'mesStyles')
	{
		if(!is_dir('style/mesStyles')) { mkdir('style/mesStyles',0777); }
		$dossier = (is_dir('style/'.$dossier))?$dossier:'mesStyles';
		$listeFichiers = scandir('style/'.$dossier);
		unset($listeFichiers[array_search('.', $listeFichiers)]);
		unset($listeFichiers[array_search('..', $listeFichiers)]);
		$resultat = '';
		foreach($listeFichiers as $css)
		{
			if(substr($css, -4) === '.css')
			{
				$resultat .= '<link rel="stylesheet" type="text/css" href="style/'.$dossier.'/'.$css.'" />
';
			}
		}
		echo '
'.$resultat;
	}
	
	
?>