<?php

	function informationSite($nom)
	{
		$nomConnus = array('meta', 'header','footer');
		$nom = (in_array(strtolower($nom), $nomConnus))?strtolower($nom):$nomConnus[0];
		require('fonctionBdd.php');
		$requete = 'SELECT * FROM `informations` WHERE `infNom` = :nom LIMIT 1';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':nom', $nom, PDO::PARAM_STR);
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_OBJ);
		return $row->infContenu;
	}
	
	function emailSite($mode = 'consulter', $email = '')
	{
		$modesDisponibles = array('consulter', 'definir');
		$mode = (in_array($mode, $modesDisponibles))?$mode:$modesDisponibles[0];
		require('fonctionBdd.php');
		if($mode == 'consulter')
		{
			$requete = 'SELECT * FROM `informations` WHERE `infNom` = "email" LIMIT 1';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			$row = $stmt->fetch(PDO::FETCH_OBJ);
			if(filter_var($row->infContenu, FILTER_VALIDATE_EMAIL))
			{
				$resultat = $row->infContenu;
			}
			else
			{
				$resultat = 'Aucune adresse n\'est actuellement définie pour le site web.<br />
				Si vous êtes administrateur du site vous devriez régler ce problème au plus vite.';
				if(strlen(str_replace(' ','',$row->infContenu)) >0)
				{
					$requete = 'UPDATE `informations` SET `infContenu` = "" WHERE `infNom` = "email"';
					$stmt = $bdd->prepare($requete);
					$stmt->execute();
					$resultat = 'L\'adresse email du site vient d\'être réinitialisée car elle était invalide.<br />
					Une nouvelle adresse sera disponible après intervention d\'un administrateur.';
				}
			}
		}
		elseif($mode == 'definir')
		{
			if(jeSuisAdmin())
			{
				if(filter_var($email, FILTER_VALIDATE_EMAIL))
				{
					$requete = 'UPDATE `informations` SET `infContenu` = :email WHERE `infNom` = "email"';
					$stmt = $bdd->prepare($requete);
					$stmt->bindParam(':email', $email, PDO::PARAM_STR);
					if($stmt->execute())
					{
						$resultat = '<b><i>'.$email.'</i></b> est maintenant l\'adresse email du site.';
					
					}
					else
					{
						$resultat = '<fieldset><legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
										<p>Une erreur est survenue lors de l\'enregistrement<br />'. $codeErreur[2] .'</p>
									</fieldset>';
					}
					
				}
				else
				{
					$resultat = '<b><i>'.$email.'</i></b> n\'est pas une adresse email acceptable. Veuillez recommencer.';
				}
			}
			else
			{
				$resultet = 'Vous ne disposez pas de suffisament de droits pour définir le compte email du site web.';
			}
		}
		return $resultat;
	}
?>