<?php
	function obtenirRubrique($champ, $valeur)
	{
		require('fonctionBdd.php');
		$_CHAMPS = array("id","redirection");
		$_JOINTURE = array('article' =>'JOIN `articles` ON `artRubrique` = `rubId`');
		$_RECHERCHER = array("id" => 'SELECT * FROM `rubriques` '.$_JOINTURE['article'].' WHERE `rubId` = '. intval($valeur) .' GROUP BY `rubId`',
		"redirection" => 'SELECT * FROM `rubriques` '.$_JOINTURE['article'].' WHERE `rubRedirection` = '. intval($valeur) .' GROUP BY `rubId`');
		$champ = (in_array($champ, $_CHAMPS))? $champ : $_CHAMPS[0] ;
		$requete = ($champ == $_CHAMPS[0])? $_RECHERCHER['id'] : $_RECHERCHER['redirection'] ;
		$stmt = $bdd->prepare($requete);
		$stmt->execute();
		$resultat = '';
		while($rub = $stmt->fetch(PDO::FETCH_OBJ))
		{
			$moteur = ($rub->rubRedirection)? 'article' : 'rubrique';
			$objet = ($moteur == 'article')? $rub->rubArticle : $rub->rubId ;
			$resultat .= '<a href="'. $moteur .'-'. $objet .'.html">'. $rub->rubNom .'</a>';
		}
		return $resultat;
	}
	function delierRubrique($id)
	{
		if(jeSuisAdmin())
		{
			require('fonctionBdd.php');
			$requete = 'UPDATE `rubriques` SET `rubRedirection` = 0 WHERE `rubRedirection` = 1 AND `rubId` = :id';
			$stmt = $bdd->prepare($requete);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			if($stmt->execute())
			{
				$nbrOperation = $stmt->rowCount();
				$operation = ($nbrOperation > 1)? $nbrOperation.' opérations effectuées: ' : 'Une opération effectuée: ';
				$resultat = $operation.' la rubrique '.$id.' n\'est plus redirigée.';
			}
			else
			{
				$codeErreur = $stmt->errorInfo();
				$resultat = 'Code erreur SQL: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2];
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas des droits suffisants pour délier une rubrique.';
		}
		return $resultat;
	}
	function lierRubrique($rubriqueId, $articleId)
	{
		if(jeSuisAdmin())
		{
			require('fonctionBdd.php');
			$requete = 'SELECT * FROM `articles` WHERE `artId` = :id';
			$stmt = $bdd->prepare($requete);
			$stmt->bindParam(':id', $articleId, PDO::PARAM_INT);
			if($stmt->execute())
			{
				if($row = $stmt->fetch(PDO::FETCH_OBJ))
				{
					$requete = 'UPDATE `rubriques` SET `rubArticle` = :articleId WHERE `rubId` = :rubriqueId';
					$stmt = $bdd->prepare($requete);
					$stmt->bindParam(':articleId', $articleId, PDO::PARAM_INT);
					$stmt->bindParam(':rubriqueId', $rubriqueId, PDO::PARAM_INT);
					if($stmt->execute())
					{
						$succes = 'La rubrique '.$rubriqueId.' a maintenant l\'article '.$articleId.' comme article de référence.';
						$echec = 'La rubrique '.$rubriqueId.' n\'existe pas. Quelqu\'un vient peut être de le supprimer.';
						$resultat = ($stmt->rowCount())? $succes: $echec;
					}
					else
					{
						$codeErreur = $stmt->errorInfo();
						$resultat = 'Une erreur est survenue. Code erreur SQL: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2];
					}
				}
				else
				{
					$resultat = 'L\'article '.$id.' n\'existe pas. Quelqu\'un vient peut être de le supprimer.';
				}
			}
			else
			{
				$codeErreur = $stmt->errorInfo();
				$resultat = 'Une erreur est survenue. Code erreur SQL: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2];
			}
			return $resultat;
		}
	}
	function redirigeRubrique($rubriqueId)
	{
		if(jeSuisAdmin())
		{
			require('fonctionBdd.php');
			$requete = 'UPDATE `rubriques` SET `rubRedirection` = 1 WHERE `rubRedirection` = 0 AND `rubId` = :id';
			$stmt = $bdd->prepare($requete);
			$stmt->bindParam(':id', $rubriqueId, PDO::PARAM_INT);
			if($stmt->execute())
			{
				$requete = 'SELECT * FROM `articles`
				JOIN `rubriques` ON `rubArticle` = `artId`
				WHERE `rubId` = :rubriqueId';
				$stmt = $bdd->prepare($requete);
				$stmt->bindParam(':rubriqueId', $rubriqueId, PDO::PARAM_INT);
				if($stmt->execute())
				{
					if($row = $stmt->fetch(PDO::FETCH_OBJ))
					{
						$resultat = 'La redirection a été activée sur la rubrique '.$rubriqueId.'. Elle redirigera donc vers l\'article '.$row->artId;
					}
					else
					{
						$resultat = 'La redirection a été activée sur la rubrique '.$rubriqueId.' mais son article de référence n\'existe pas.';
					}
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					$resultat = 'Une erreur est survenue. Code erreur SQL: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2];
				}
			}
			else
			{
				$codeErreur = $stmt->errorInfo();
				$resultat = 'Une erreur est survenue. Code erreur SQL: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2];
			}
			return $resultat;
		}
	}
	function supprimerRubrique($rubrique, $deplacement)
	{
		if(jeSuisAdmin())
		{
			require('fonctionBdd.php');
			$requete = 'UPDATE `articles` SET `artRubrique` = :deplacementId WHERE `artRubrique` = :rubriqueId';
			$stmt = $bdd->prepare($requete);
			$stmt->bindParam(':rubriqueId', $rubrique, PDO::PARAM_INT);
			$stmt->bindParam(':deplacementId', $deplacement, PDO::PARAM_INT);
			$stmt->execute();
			$nbrDeplacement = $stmt->rowCount();
			switch($nbrDeplacement)
			{
				case 0:
				$resultatDeplacement = 'La rubrique '.$rubrique.' ne contenait aucun article.';
				break;
				case 1:
				$resultatDeplacement = 'Un article a été deplacé de la rubrique '.$rubrique.' vers la rubrique '.$deplacement;
				default:
				$resultatDeplacement = $nbrDeplacement.' ont été déplacés de la rubrique '.$rubrique.' vers la rubrique '.$deplacement;
				break;
			}
			$requete = 'DELETE FROM `rubriques` WHERE `rubId` = :rubriqueId';
			$stmt = $bdd->prepare($requete);
			$stmt->bindParam(':rubriqueId', $rubrique, PDO::PARAM_INT);
			if($stmt->execute())
			{
				$nbrEffacement = $stmt->rowCount();
				switch($nbrEffacement)
				{
					case 0:
					$resultatEffacement = 'La rubrique '.$rubrique.' n\'existe pas. Quelqu\'un l\'a peut être supprimée juste avant vous.';
					break;
					case 1:
					$resultatEffacement = 'La rubrique '.$rubrique.' a été supprimée avec succes.';
					break;
					default:
					$resultatEffacement = 'Un problème est peut être survenu. '.$nbrEffacement.' rubriques ont été supprimées au lieu d\'une comme prévu. Vérifiez que vous n\'avez pas perdu vos données.';
					break;
				}
			}
			else
			{
				$codeErreur = $stmt->errorInfo();
				$resultatEffacement = 'Une erreur est survenue. Code erreur SQL: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2];
			}
			$resultat = $resultatDeplacement.' '.$resultatEffacement;
		}
		else
		{
			$resultat = 'Vous ne disposez pas des droits suffisants pour supprimer les paramètre d\'une rubrique.';
		}
		return $resultat;
	}
	function obtenirListeEpingleRubrique()
	{
		require('fonctionBdd.php');
		$requete = 'SELECT `rubId` FROM `rubriques` WHERE `rubEpingle` = 1';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':id', $id, PDO::PARAM_INT);
		$stmt->execute();
		$rubriquesEpinglees = false;
		while($row = $stmt->fetch(PDO::FETCH_OBJ))
		{
			$rubriquesEpinglees[] = $row->rubId;
		}
		$resultat = (count($rubriquesEpinglees) > 0)?$rubriquesEpinglees:false;
		return $resultat;
	}
	function desepinglerRubrique($id)
	{
		$id = intval($id);
		require('fonctionBdd.php');
		$requete = 'UPDATE `rubriques` SET `rubEpingle` = 0 WHERE `rubId` = :id';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':id', $id, PDO::PARAM_INT);
		if($stmt->execute())
		{
			$resultat = 'La rubrique a été désépinglée avec succes.';
		}
		else
		{
			$codeErreur = $stmt->errorInfo();
			$resultat = '<br /><fieldset>
				<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
				<p>'. $codeErreur[2] .'</p>
			</fieldset>';
		}
		return $resultat;
	}
	function epinglerRubrique($id)
	{
		$id = intval($id);
		require('fonctionBdd.php');
		$requete = 'UPDATE `rubriques` SET `rubEpingle` = 1 WHERE `rubId` = :id';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':id', $id, PDO::PARAM_INT);
		if($stmt->execute())
		{
			$resultat = 'La rubrique a été épinglée avec succes';
		}
		else
		{
			$codeErreur = $stmt->errorInfo();
			$resultat = '<br /><fieldset>
				<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
				<p>'. $codeErreur[2] .'</p>
			</fieldset>';
		}
		return $resultat;
	}
	function nomRubrique($id)
	{
		require('fonctionBdd.php');
		$requete = 'SELECT `rubNom` FROM `rubriques` WHERE `rubId` = :id';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':id', $id, PDO::PARAM_INT);
		$stmt->execute();
		if($row = $stmt->fetch(PDO::FETCH_OBJ)) { $resultat = $row->rubNom; }
		else { $resultat = 'Rubrique inconnue'; }
		return $resultat;
	}
?>