<?php
	
	/*
		Fonction protégées Formulaire.
		Ces fonctions du gestionnaire formulaire sont isolées de leurs soeurs
		afin qu'elles ne puissent pas être modifiée depuis le back-office du logiciel.
	*/
	
	function connexionFormulaire()
	{
		require('fonctionBdd.php');
		$_POST['email'] = (empty($_POST['email']))? '' : $_POST['email'];
		$_POST['code'] = (empty($_POST['code']))? '' : md5($_POST['code']);
		$requete = 'SELECT * FROM `personnes` WHERE `perEmail` = :email AND `perCode` = :code LIMIT 1';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
		$stmt->bindParam(':code', $_POST['code'], PDO::PARAM_STR);
		$stmt->execute();
		if($resultat = $stmt->fetch(PDO::FETCH_OBJ))
		{
			if($resultat->perActivite)
			{
				$_SESSION['utilisateur'] = array("connecte" => true, "id" => $resultat->perId, "email" => $resultat->perEmail, "role" => intval($resultat->perRole), "prenom" => $resultat->perPrenom, "nom" => $resultat->perNom);
				
				$res = 'Connexion réussie. Vous allez être redirigé sur la page d\'accueil de l\'administration.<br />
				<a href="?moteur=administration&objet=index">Cliquez-ici si la redirection automatique ne fonctionne pas.</a>
				<script laguage="JavaScript">document.location.href="?moteur=administration&objet=index"</script>';
			}
			else
			{
				if(time() > strtotime($resultat->perPeremption))
				{
					$_SESSION['utilisateur'] = array("connecte" => false);
					$res = 'Connexion échouée <a id="pagePrecedente"></a>';
				}
				else
				{
					$_SESSION['utilisateur'] = array("connecte" => false);
					$res = 'Ce compte a été désactivé. Sa supprésion est prévu le '.$resultat->perPeremption.'<br />
					Pour demander sa réactivation contactez un administrateur en utlisant votre adresse email <b>'.$resultat->perEmail .'</b>.';
				}
			}
		}
		else
		{
			$_SESSION['utilisateur'] = array("connecte" => false);
			$res = 'Connexion échouée <a id="pagePrecedente"></a>';
		}
		return $res;
	}
	function deconnexionFormulaire()
	{
		$_SESSION['utilisateur'] = array("connecte" => false);
		$message = 'Vous êtes maintenant déconnecté. Vous allez être redirigé sur la page d\'accueil du site.<br />
				<a href="?moteur=indexx">Cliquez-ici si la redirection automatique ne fonctionne pas.</a>
				<script laguage="JavaScript">document.location.href="?moteur=index"</script>';
		return $message;
	}
	function articleFormulaire()
	{
		if(jeFaisPartieDuStaff())
		{
			require('fonctionBdd.php');
			$resultat = 'Oups ! Une erreur est survenue lors de la création de cet article.<a id="pagePrecedente"></a>';
			
			$_POST['articleTitre'] = (strlen($_POST['articleTitre']) < 1)? 'Sans titre du '.date('d/m/y h:i:s', time()) : $_POST['articleTitre'] ;
			$_POST['articleTitre'] = strip_tags($_POST['articleTitre']);
			$date = date("Y-m-d H:i:s");
			$_POST['articleRubrique'] = explode(':', $_POST['articleRubrique']);
			$_POST['nomRubrique'] = $_POST['articleRubrique'][1];
			$_POST['articleRubrique'] = explode('Rubrique ', $_POST['articleRubrique'][0]);
			$_POST['articleRubrique'] = max(1, intval($_POST['articleRubrique'][1]));
			// $_POST['contenuArticle'] = strip_tags($_POST['contenuArticle'], '<div><p><a><span><i><u><b><del><h1><h2><h3><h4><h5>');
			if($_POST['articleId'] == 'nouveau')
			{
				$requete = 'INSERT INTO `articles`
				(`artTitre`, `artDate`, `artValide`, `artRubrique`, `artAuteur`, `artContenu`)
				VALUES (:titre, :date, 0, :rubrique, :auteur, :contenu);';
				$stmt = $bdd->prepare($requete);
				$stmt->bindParam(':titre', $_POST['articleTitre'], PDO::PARAM_STR);
				$stmt->bindParam(':date', $date, PDO::PARAM_STR);
				$stmt->bindParam(':rubrique', $_POST['articleRubrique'], PDO::PARAM_INT);
				$stmt->bindParam(':auteur', $_SESSION['utilisateur']['id'], PDO::PARAM_INT);
				$stmt->bindParam(':contenu', $_POST['contenuArticle'], PDO::PARAM_STR);
				if($stmt->execute())
				{
					$_POST['articleId'] = $bdd->lastInsertId();
					$resultat = 'L\'article <b>'. $_POST['articleTitre'] .'</b> associé à la rubrique <a href="?moteur=rubrique&objet='.$_POST['articleRubrique'].'">'.$_POST['nomRubrique'].'</a> a été ajouté à la liste des articles en attente de validation.<br />
					<a href="?moteur=editer&objet=article;'. $_POST['articleId'] .'">Cliquez ici</a> pour l\'éditer.';
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					$resultat .= '<br /><fieldset>
						<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
						<p>'. $codeErreur[2] .'</p>
					</fieldset>'; $stmt->errorInfo();
				}
			}
			else
			{
				$requete = "UPDATE `articles`
							SET `artTitre` = :titre, `artRubrique` = :rubrique, `artContenu` = :contenu
							WHERE `artId` = :id";
				$stmt = $bdd->prepare($requete);
				$stmt->bindParam(':titre', $_POST['articleTitre'], PDO::PARAM_STR);
				$stmt->bindParam(':rubrique', $_POST['articleRubrique'], PDO::PARAM_INT);
				$stmt->bindParam(':contenu', $_POST['contenuArticle'], PDO::PARAM_STR);
				$stmt->bindParam(':id', $_POST['articleId'], PDO::PARAM_INT);
				if($stmt->execute())
				{
					$resultat = 'L\'article <b><a href="?moteur=article&objet='. $_POST['articleId'].'">'. $_POST['articleTitre'] .'</a></b> a été édité avec succes. Il est associé à la rubrique <a href="?moteur=rubrique&objet='.$_POST['articleRubrique'].'">'.$_POST['nomRubrique'].'</a>. Son statut (<i>"publié"</i> ou <i>"en attente de validation"</i>) n\'a pas changé<br />
					<a href="?moteur=editer&objet=article;'. $_POST['articleId'] .'">Cliquez ici</a> pour l\'éditer à nouveau.<br />
					<a href="?moteur=administration&objet=article">Cliquez ici</a> pour revenir à l\'administration des articles';
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					$resultat .= '<br /><fieldset>
						<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
						<p>'. $codeErreur[2] .'</p>
					</fieldset>'; $stmt->errorInfo();
				}
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de droits suffisants pour créer des articles.
			<a id="pagePrecedente"></a>';
		}
		return $resultat;
	}
	function rubriqueFormulaire()
	{
		if(jeFaisPartieDuStaff())
		{
			require('fonctionBdd.php');
			$resultat = 'Oups ! Une erreur est survenue lors de la création de cet article.<a id="pagePrecedente"></a>';
			if($_POST['rubriqueId'] == 'nouveau')
			{
				$_POST['rubriqueRedirection'] = ($_POST['rubriqueRedirection'] === NULL)?0:intval($_POST['rubriqueRedirection']);
				$requete = 'INSERT INTO `rubriques` (`rubNom`, `rubRedirection`, `rubArticle`) VALUES (:nom, :redirection, :article);';
				$stmt = $bdd->prepare($requete);
				$stmt->bindParam(':nom', $_POST['rubriqueNom'], PDO::PARAM_STR);
				$stmt->bindParam(':redirection', $_POST['rubriqueRedirection'], PDO::PARAM_INT);
				$stmt->bindParam(':article', $_POST['rubriqueArticle'], PDO::PARAM_INT);
				if($stmt->execute())
				{
					$_POST['rubriqueId'] = $bdd->lastInsertId();
					$resultat = 'La rubrique <b>'. $_POST['rubriqueId'] .'</b> a été créée avec succès.<br />
					Vous pouvez la modifier en cliquant sur <a href="?moteur=administration&objet=rubrique">Gérer les rubriques</a>';
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					if($codeErreur[2] == 'Duplicate entry \''.$_POST['rubriqueNom'].'\' for key \'rubNom\'')
					{
						$codeErreur[2] = 'Le nom <b>"'.$_POST['rubriqueNom'].'"</b> est déjà utilisé pour une autre rubrique';
					}
					$resultat .= '<br /><fieldset>
						<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
						<p>'. $codeErreur[2] .'</p>
					</fieldset>'; $stmt->errorInfo();
				}
			}
			else
			{
				$_POST['rubriqueRedirection'] = (empty($_POST['rubriqueRedirection']) || $_POST['rubriqueRedirection'] === NULL)?0:intval($_POST['rubriqueRedirection']);
				$requete = "UPDATE `rubriques` SET `rubNom` = :nom, `rubRedirection` = :redirection, `rubArticle` = :article WHERE `rubId` = :id";
				$stmt = $bdd->prepare($requete);
				$stmt->bindParam(':id', $_POST['rubriqueId'], PDO::PARAM_INT);
				$stmt->bindParam(':nom', $_POST['rubriqueNom'], PDO::PARAM_STR);
				$stmt->bindParam(':redirection', $_POST['rubriqueRedirection'], PDO::PARAM_INT);
				$stmt->bindParam(':article', $_POST['rubriqueArticle'], PDO::PARAM_INT);
				if($stmt->execute())
				{
					$resultat = 'La rubrique <b>'. $_POST['rubriqueId'] .'</b> a été éditée avec succès.<br />
					<a href="?moteur=administration&objet=rubrique">Gérer à nouveau cette rubriques</a><br />
					<a href="?moteur=administration&objet=rubrique">Aller à la gestion les rubriques</a>';
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					if($codeErreur[2] == 'Duplicate entry \''.$_POST['rubriqueNom'].'\' for key \'rubNom\'')
					{
						$codeErreur[2] = 'Le nom <b>"'.$_POST['rubriqueNom'].'"</b> est déjà utilisé pour une autre rubrique';
					}
					$resultat .= '<br /><fieldset>
						<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
						<p>'. $codeErreur[2] .'<br />Duplicate entry \''.$_POST['rubriqueNom'].'\' for key \'rubNom\'</p>
					</fieldset>';
				}
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de droits suffissants pour créer des rubriques.
			<a id="pagePrecedente"></a>';
		}
		$resultat .= '<br ><a href="administration-index.html">Revenir sur la page d\'administration</a>
					  <br /><a href="index.html">Revenir au site en acces public</a>';
		return $resultat;
	}
	function profilFormulaire()
	{
		if($_POST['id'] == 'nouveau')
		{
			if(jeSuisAdmin())
			{
				require('fonctionBdd.php');
				$erreur = array();
				$_POST['nom'] = strip_tags(preg_replace('#[^A-Za-z0-9]+#', '-', $_POST['nom']));
				$_POST['prenom'] = strip_tags(preg_replace('#[^A-Za-z0-9]+#', '-', $_POST['prenom']));
				$_POST['mail'] = strip_tags($_POST['email']);
				$_POST['role'] = ( intval($_POST['role']) == 1)?1:2;
				$_POST['description'] = (empty($_POST['description']))?'':$_POST['description'];
				if(strlen($_POST['nom']) < 4 || strlen($_POST['nom']) > 10) { $erreur[] = 'Le nom doit être un mot comprise entre 4 et 10 caractères.'; }
				if(strlen($_POST['prenom']) < 4 || strlen($_POST['prenom']) > 10) { $erreur[] = 'Le prenom doit être un mot comprise entre 4 et 10 caractères.'; }
				if(filter_var($_POST['email'], FILTER_VALIDATE_EMAIL))
				{
					$requete = 'SELECT COUNT(`perEmail`) as `mailIndisponible` FROM `personnes` WHERE `perEmail` = :email';
					$stmt = $bdd->prepare($requete);
					$stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
					if($stmt->execute())
					{
						$res = $stmt->fetch(PDO::FETCH_OBJ);
						if($res->mailIndisponible) { $erreur[] = 'L\'adresse email est déjà utilisée.'; }
					}
					else
					{
						$codeErreur = $stmt->errorInfo();
						$erreur[] = '<fieldset><legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend><p>'. $codeErreur[2] .'</p>	</fieldset>';
					}
				}
				else { $erreur[] = 'Le format de l\'adresse email est invalide'; }
				if(count($erreur) > 0)
				{
					$resultat = implode('<br />', $erreur).'<a id="pagePrecedente"></a>';
				}
				else
				{
					$lettre = array('a','z','e','r','t','y','u','i','o','p','q','s','d','f','g','h','j','k','l','m','w','x','c','v','b','n');
					$code = base64_encode($_POST['nom']).'-';
					for($i=0;$i<8;$i++)
					{
						$a = rand(0,25); $b = rand(0,1); $c = rand(0,18);
						$char = ($b)?strtoupper($lettre[$a]):$lettre[$a];
						$char .= ($c > 9)?'':$c;
						$code .= $char;
					}
					$codeMd5 = md5($code);
					$requete = 'INSERT INTO `personnes` (`perEmail`, `perCode`, `perRole`, `perPrenom`, `perNom`, `perDescription`)
					VALUES (:email, :code, :role, :prenom, :nom, :description)';
					$stmt = $bdd->prepare($requete);
					$stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
					$stmt->bindParam(':nom', $_POST['nom'], PDO::PARAM_STR);
					$stmt->bindParam(':prenom', $_POST['prenom'], PDO::PARAM_STR);
					$stmt->bindParam(':role', $_POST['role'], PDO::PARAM_INT);
					$stmt->bindParam(':code', $codeMd5, PDO::PARAM_STR);
					$stmt->bindParam(':description', $_POST['description'], PDO::PARAM_STR);
					if($stmt->execute())
					{
						$nbrOperation = $stmt->rowCount();
						$resultat = ($nbrOperation)?'Le compte a été crée avec succes. Un email contenant le mot de passe a été envoyé à '.$_POST['email']:'Une erreur est peut être survenue lors de la création du compte. Vérifiez qand même la boite mail '. $_POST['mail'].'. Elle a peut être reçu un couriel contenant le mot de passe du compte qui lui est associé. <a id="pagePrecedente"></a>';
						$resultat .= '<span>'.menuAdministration().'</span>';
					}
					else
					{
						$codeErreur = $stmt->errorInfo();
						$resultat = '<fieldset><legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend><p>'. $codeErreur[2] .'</p>	</fieldset>';
					}
				}
			}
			else
			{
				$resultat = 'Vous ne disposez pas des droits suffisants pour créer un nouvel utilisateurs';
			}
		}
		elseif(jeSuisAdmin() || cMonProfil($_POST['id']))
		{
			$_POST['id'] = intval($_POST['id']);
			$_POST['description'] = (empty($_POST['description']))?'':$_POST['description'];
			require('fonctionBdd.php');
			if(cMonProfil($_POST['id']))
			{
				$requete = $requeteUtilisateur = 'UPDATE `personnes`
				SET `perNom` = :nom, `perPrenom` = :prenom, `perEmail` = :email,`perCode` = :nouveauCode, `perRole` = :role, `perActivite` = :activite, `perDescription` = :description, `perPeremption` = NOW() + INTERVAL 1 DAY
				WHERE `perId` = :id, AND `perCode` = :code';
				$stmt = $bdd->prepare($requeteUtilisateur);
				$stmt->bindParam(':id', $_POST['id'], PDO::PARAM_INT);
				$stmt->bindParam(':nom', $_POST['nom'], PDO::PARAM_STR);
				$stmt->bindParam(':prenom', $_POST['prenom'], PDO::PARAM_STR);
				$stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
				$stmt->bindParam(':nouveauCode', $_POST['nouveauCode'], PDO::PARAM_STR);
				$stmt->bindParam(':role', $_POST['role'], PDO::PARAM_INT);
				$stmt->bindParam(':code', $_POST['code'], PDO::PARAM_INT);
				$stmt->bindParam(':description', $_POST['description'], PDO::PARAM_STR);
				$stmt->bindParam(':activite', $_POST['activite'], PDO::PARAM_INT);
			}
			else
			{
				$requete = $requeteUtilisateur = 'UPDATE `personnes`
				SET `perNom` = :nom, `perPrenom` = :prenom, `perEmail` = :email, `perRole` = :role, `perActivite` = :activite, `perPeremption` = NOW() + INTERVAL 1 DAY
				WHERE `perId` = :id';
				$stmt = $bdd->prepare($requeteUtilisateur);
				$stmt->bindParam(':id', $_POST['id'], PDO::PARAM_INT);
				$stmt->bindParam(':nom', $_POST['nom'], PDO::PARAM_STR);
				$stmt->bindParam(':prenom', $_POST['prenom'], PDO::PARAM_STR);
				$stmt->bindParam(':email', $_POST['email'], PDO::PARAM_STR);
				$stmt->bindParam(':role', $_POST['role'], PDO::PARAM_INT);
				$stmt->bindParam(':activite', $_POST['activite'], PDO::PARAM_INT);
			}
			if($stmt->execute())
			{
				if($stmt->rowCount())
				{
					$messageAdmin = '<br /><a href="?moteur=administration&objet=index">Cliquez ici pour revenir à l\'administration</a><br />
					<a href="?moteur=administration&objet=utilisateur">Cliquez ici pour revenir à la gestions des utilisateurs</a>';
					$resultat = 'Opération effectuée avec succes. <a href="?moteur=editer&objet=personne;'.$_POST['id'].'">Cliquez-ici pour éditer ce compte à nouveau</a><br />
					<a href="?moteur=index">Cliquez ici pour retourner sur la page d\'accueil</a>';
					$resultat = (jeSuisAdmin())?$resultat.$messageAdmin:$resultat;
				}
				else
				{
					$messageAdmin = '<br /><a href="?moteur=administration&objet=index">Cliquez ici pour revenir à l\'administration</a><br />
					<a href="?moteur=administration&objet=utilisateur">Cliquez ici pour revenir à la gestions des utilisateurs</a>';
					$resultat = 'Aucun changement effectué. <a href="?moteur=editer&objet=personne;'.$_POST['id'].'">Cliquez-ici pour éditer ce compte à nouveau</a><br />
					<a href="?moteur=index">Cliquez ici pour retourner sur la page d\'accueil</a>';
					$resultat = (jeSuisAdmin())?$resultat.$messageAdmin:$resultat;
				}
			}
			else
			{
				$codeErreur = $stmt->errorInfo();
				$resultat .= '<br /><fieldset>
					<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
					<p>'. $codeErreur[2] .'<br />Duplicate entry \''.$_POST['rubriqueNom'].'\' for key \'rubNom\'</p>
				</fieldset>';
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas des droits suffisants pour modifier ce profil.
			<a>:precedent</a>';
		}
		return $resultat;
	}
	
	function metaInfoFormulaire()
	{
		if(jeSuisAdmin())
		{
			$_POST['metaInfo'] = empty($_POST['metaInfo'])?'':$_POST['metaInfo'];
			$erreur = 'La longueur des meta informations doit être comprise entre 20 et 5000 caractères.
					<a id="pagePrecedente"></a>
					<a href="?moteur=administration&objet=index">Revenir sur  l\'index d\'administration</a>';
			if(strlen($_POST['metaInfo']) < 20)
			{
				$resultat ='<br /><fieldset><legend>Texte trop court</legend>'.$erreur.'</fieldset>';
			}
			elseif(strlen($_POST['metaInfo']) > 5000)
			{
				$resultat ='<br /><fieldset><legend>Texte trop long</legend>'.$erreur.'</fieldset>';
			}
			else
			{
				require('fonctionBdd.php');
				$requete = "UPDATE `informations` SET `infContenu` = :metaInfo WHERE `infNom` = 'meta'";
				$stmt = $bdd->prepare($requete);
				$stmt->bindParam(':metaInfo', $_POST['metaInfo'], PDO::PARAM_STR);
				if($stmt->execute())
				{
					$resultat = 'Les méta information de votre site web ont été effectuée avec succes.<br />
					<a href="?moteur=editer&objet=meta">Re-éditer les méta informations du site web</a><br />
					<a href="?moteur=administration&objet=index">Aller à l\'index d\'administration du site web</a>';
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					$resultat .= '<br /><fieldset>
						<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
						<p>'. $codeErreur[2] .'</p>
					</fieldset>';
				}
			}
		}
		else
		{
			$resultat = 'Vous ne diposez pas de droits suffisants pour modifier les métas-informations du site';
		}
		return $resultat;
	}
	
	function headerFormulaire()
	{
		if(jeSuisAdmin())
		{
			$_POST['header'] = empty($_POST['header'])?'':$_POST['header'];
			$erreur = 'La longueur de l\'entête du site web doit être comprise entre 20 et 5000 caractères.
					<a id="pagePrecedente"></a>
					<a href="?moteur=administration&objet=index">Revenir sur  l\'index d\'administration</a>';
			if(strlen($_POST['header']) < 20)
			{
				$resultat ='<br /><fieldset><legend>Texte trop court</legend>'.$erreur.'</fieldset>';
			}
			elseif(strlen($_POST['header']) > 5000)
			{
				$resultat ='<br /><fieldset><legend>Texte trop long</legend>'.$erreur.'</fieldset>';
			}
			else
			{
				require('fonctionBdd.php');
				$requete = "UPDATE `informations` SET `infContenu` = :header WHERE `infNom` = 'header'";
				$stmt = $bdd->prepare($requete);
				$stmt->bindParam(':header', $_POST['header'], PDO::PARAM_STR);
				if($stmt->execute())
				{
					$resultat = 'L\'entête de votre site web a été effectuée avec succes.<br />
					<a href="?moteur=editer&objet=header">Re-éditer l\'entête du site web</a><br />
					<a href="?moteur=administration&objet=index">Aller à l\'index d\'administration du site web</a>';
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					$resultat .= '<br /><fieldset>
						<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
						<p>'. $codeErreur[2] .'</p>
					</fieldset>';
				}
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de suffisament de doits pour modifier l\'entpete du site?
			<a id="pagePrecedente"></a>';
		}
		return $resultat;
	}
	
	function footerFormulaire()
	{
		if(jeSuisAdmin())
		{
			$_POST['footer'] = empty($_POST['footer'])?'':$_POST['footer'];
			$erreur = 'La longueur du pied de page du site web doit être comprise entre 20 et 5000 caractères.
					<a id="pagePrecedente"></a>
					<a href="?moteur=administration&objet=index">Revenir sur  l\'index d\'administration</a>';
			if(strlen($_POST['footer']) < 20)
			{
				$resultat ='<br /><fieldset><legend>Texte trop court</legend>'.$erreur.'</fieldset>';
			}
			elseif(strlen($_POST['footer']) > 5000)
			{
				$resultat ='<br /><fieldset><legend>Texte trop long</legend>'.$erreur.'</fieldset>';
			}
			else
			{
				require('fonctionBdd.php');
				$requete = "UPDATE `informations` SET `infContenu` = :footer WHERE `infNom` = 'footer'";
				$stmt = $bdd->prepare($requete);
				$stmt->bindParam(':footer', $_POST['footer'], PDO::PARAM_STR);
				if($stmt->execute())
				{
					$resultat = 'Le pied de page de votre site a été modifié avec succes.<br />
					<a href="?moteur=editer&objet=footer">Re-éditer lee pied de page du site web</a><br />
					<a href="?moteur=administration&objet=index">Aller à l\'index d\'administration du site web</a>';
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					$resultat .= '<br /><fieldset>
						<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
						<p>'. $codeErreur[2] .'</p>
					</fieldset>';
				}
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de droits suffisants pour modifier le pied de page du site.
			<a id="pagePrecedente"></a>';
		}
		return $resultat;
	}
	
	function modifierFonctionFormulaire()
	{
		if(jeSuisAdmin())
		{
			$gestionnairesModifiables = array('Personnelle', 'Formulaire');
			$_POST['gestionnaire'] = (in_array($_POST['gestionnaire'],$gestionnairesModifiables))?$_POST['gestionnaire']:$gestionnairesModifiables[0];
			$fichier = ($_POST['gestionnaire'] == 'Personnelle')?'php/fonctionsPersonnelles.php':'php/fonctionsFormulaires.php';
			if(file_exists($fichier))
			{
				$_POST['nomComplet'] = $_POST['nom'].$_POST['gestionnaire'];
				$contenuFichier	= str_replace(array('<?php', '?>'),'',file_get_contents($fichier));
				$decoupeFichier = explode('function ', $contenuFichier);
				$i = 0;
				$case = (-1);
				
				while($i !== false)
				{
					$descriptionFonction = $decoupeFichier[$i];
					$position = stripos($descriptionFonction, $_POST['nomComplet']);
					if($position === 0)
					{
						$case = $i;
						$i = false;
					}
					else
					{
						$i++;
					}
					$i = ($i>count($decoupeFichier))?false:$i;
				}
				$copieDecoupe = str_replace(array(' ', "\t", "\n", "\r"),'',$decoupeFichier);
				
				foreach($copieDecoupe as $key => $element)
				{
					if(strlen($element) == 0)
					{
						unset($decoupeFichier[$key]);
					}
				}
				
				if($case >= 0)
				{
					$decoupeFichier[$case] = '';
					$decoupeFichier[$case] = $_POST['nomComplet'].'('.$_POST['arguments'].')
{
	'.$_POST['instructions'].'
}';
					$nouveauContenu = 'function '.implode('function ', $decoupeFichier);
					file_put_contents($fichier, '<?php
'.$nouveauContenu.'
?>', LOCK_EX);
					$legendResultat = "Opération effectuée avec succes";
					$resultat = 'La fonction <i>'.$_POST['nom'].'</i> du gestionnaire de fonctions <i>'.$_POST['gestionnaire'].'</i> a bien été modifiée.
					';
				}
				else
				{
					$legendResultat = "Erreur";
					$resultat = 'Impossible de trouver la fonction '.$_POST['nomComplet'].' dans le gestionnaire de fonctions <i>'.$_POST['gestionnaire'].'</i>
					<a id="pagePrecedente"></a>';
				}
			}
			else
			{
				$legendResultat = "Erreur";
				$resultat = 'Impossible de trouver le fichier associer au gestionnaire de fonctions <i>'.$_POST['gestionnaire'].'</i>
				<a id="pagePrecedente"></a>';
			}
			$resultat = '<fieldset>
					<legend>'.$legendResultat.'</legend>
						'.$resultat.'<br />
						<a href="?moteur=fonctions&objet=liste">Cliquez ici pour revenir sur le gestionnaire avancée</a><br />
						<a href="?moteur=administration&objet=index">Cliquez ici pour revenir à l\'index d\'administration</a><br />
						<a href="?moteur=index">Cliquez ici aller sur le site en acces public</a><br />
					</fieldset>';
		}
		else
		{
			$legendResultat = "Acces refusé";
			$resultat = 'Vous n\'avez pas les droits suffisants pour modifier les fonctions du programme.';
		}
		return $resultat;
	}
	
	function creationFonctionFormulaire()
	{
		if(jeSuisAdmin())
		{
			$gestionnairesAutorisees = array('Personnelle', 'Formulaire');
			$_POST['nom'] = str_replace(array('(',')','<?','?>'), '', $_POST['nom']);
			$_POST['arguments'] = str_replace(array('(',')','<?','?>'), '', $_POST['arguments']);
			$_POST['instructions'] = str_replace(array('<?php','?>'), '', $_POST['instructions']);
			if(!empty($_POST['nom']) && !empty($_POST['instructions']))
			{
				$_POST['gestionnaire'] = (in_array($_POST['gestionnaire'], $gestionnairesAutorisees))?$_POST['gestionnaire']:$gestionnairesAutorisees[0];
				$_POST['nomComplet'] = $_POST['nom'].$_POST['gestionnaire'];
				$fichier = ($_POST['gestionnaire'] == 'Personnelle')?'php/fonctionsPersonnelles.php':'php/fonctionsFormulaires.php';
				$contenu = str_replace(array('<?php','?>'),'',file_get_contents($fichier));
				if(function_exists($_POST['nomComplet']) || strpos('function '.$_POST['nomComplet'], $contenu) !== false)
				{
					$legendResultat = "Nom indisponible";
					$resultat = 'Une fonction nommée <i>'.$_POST['nom'].'</i> est déjà intégrée au gestionnaire de fonction <i>'.$_POST['gestionnaire'].'</i>
					<a id="pagePrecedente"></a>';
				}
				else
				{
					if(file_exists($fichier))
					{
						$fonction = 'function '.$_POST['nomComplet'].'('.$_POST['arguments'].')
{
	'.$_POST['instructions'].'
}';
						
						file_put_contents($fichier, '<?php'.$contenu.'
'.$fonction.'
?>');
						$legendResultat = "Opération terminée";
						$resultat = 'La fonction '.$_POST['nom'].' a été crééer et intégrée dans le gestionnaire de fonction <i>'.$_POST['gestionnaire'].'</i> avec succès.';
					}
					else
					{
						$legendResultat = "Erreur";
						$resultat = 'Impossible de trouver le fichier associer au gestionnaire de fonctions <i>'.$_POST['gestionnaire'].'</i>
						<a id="pagePrecedente"></a>';
					}
				}
			}
			else
			{
				
				$legendResultat = "Création refusée";
				$resultat = 'La fonction '.$_POST['nom'].' n\'a pas été intégrée au gestionnaire '.$_POST['gestionnaire'].' car vous avez mal rempli le formulaire.<br />
				Les champs <b>nom</b> et <b>instructions</b> doivent être remplis.
				<a id="pagePrecedente"></a>';
			}
		}
		else
		{
			$legendResultat = "Acces refusé";
			$resultat = 'Vous n\'avez pas les droits suffisants pour modifier les fonctions du programme.
			<a id="pagePrecedente"></a>';
		}
		$resultat = '<fieldset>
			<legend>'.$legendResultat.'</legend>
			'.$resultat.'<br />
			<a href="?moteur=fonctions&objet=creation">Cliquez ici pour revenir sur le de creation de fonction</a><br />
			<a href="?moteur=administration&objet=index">Cliquez ici pour revenir à l\'index d\'administration</a><br />
			<a href="?moteur=index">Cliquez ici aller sur le site en acces public</a><br />
		</fieldset>';
		return $resultat;
	}
?>