<?php

	function visualiserProfil($id = 0)
	{
		$id = max(1,intval($id));
		require('fonctionBdd.php');
		$requete = 'SELECT * FROM `personnes` WHERE `perId` = :id';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':id', $id, PDO::PARAM_INT);
		$stmt->execute();
		if($row = $stmt->fetch(PDO::FETCH_OBJ))
		{
			$requete = 'SELECT * FROM `articles` WHERE `artAuteur` = :id';
			$stmt = $bdd->prepare($requete);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
			$listeArticles = array();
			while($res = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$listeArticles[] = '<li><a href="article-'.$res->artId.'.html">'. $res->artTitre .'</a> le '.$res->artDate.' dans la rubrique <a href="rubrique-'.$res->artRubrique.'.html">'.nomRubrique($res->artRubrique).'</a></li>';
			}
			$rechercher = array(':nom',':prenom',':email',':description',':listeArticles');
			$remplacer = array($row->perNom, $row->perPrenom, $row->perEmail, $row->perDescription, implode('', $listeArticles));
			$profil = str_replace($rechercher, $remplacer, architectureProfil());
		}
		else
		{
			$profil = architectureProfil(0);
		}
		$rubriqueRedirigee = obtenirRubrique("redirection", true);
		$rubriqueNormale = obtenirRubrique("redirection", false);
		
		$resultat = obtenirSlider($rubriqueRedirigee, obtenirSlideshow(), $rubriqueNormale);
		$resultat .= obtenirContent(array($profil));
		echo $resultat;
	}
	
	function architectureProfil($contenu = true)
	{
		$profilExistant = '<fieldset><legend>Profil de :nom :prenom</legend><table><tr><td style="vertical-align:top;"><fieldset style="min-height:8em;"><legend>Contacter</legend><table><tr><td>Nom: </td><td>:nom</td></tr><tr><td>Prenom: </td><td>:prenom</td></tr><tr><td>Email: </td><td>:email</td></tr></table></fieldset><td><td style="vertical-align:top;"><fieldset style="min-height:8em;"><legend>Description</legend>:description</fieldset><td><tr></table><fieldset><legend>Articles</legend><ul>:listeArticles</ul></fieldset></fieldset>';
		$profilInexistant = '<fieldset><legend>Erreur</legend><p>Le profil que vous avez demandé n\'existe pas</p></fieldset>';
		$resultat = ($contenu)?$profilExistant:$profilInexistant;
		return $resultat;
	}

?>