<?php
	function preparerMoteur(&$nom)
	{
		require('fonctionBdd.php');
		$requete = 'SELECT * FROM `moteurs` WHERE `motNom` = :moteur ORDER BY `motId` LIMIT 1';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':moteur', $nom, PDO::PARAM_STR);
		$stmt->execute();
		$resultat = ($mot = $stmt->fetch(PDO::FETCH_OBJ))? str_replace(' ','',$mot->motNom):'index';
		$nom = (function_exists($resultat.'Moteur'))? $resultat.'Moteur': 'indexMoteur';
	}
	function utiliserMoteur($moteur)
	{
		preparerMoteur($moteur);
		$parametres = (empty($_GET['objet']))? array(): explode(';', $_GET['objet']);
		$moteur($parametres);
	}
	function indexMoteur($parametres = array())
	{
		$rubriqueRedirigee = obtenirRubrique("redirection", true);
		$rubriqueNormale = obtenirRubrique("redirection", false);
		$slideshow = obtenirSlideshow();
		$slider = obtenirSlider($rubriqueRedirigee, $slideshow, $rubriqueNormale);
		
		$une = obtenirArticle('apres_date', '2010', 'une', 3);
		$articleEpingle = obtenirArticle('epingle', 1, 'breve', 1);
		$debutDeLaPage = '<h1>Actualités</h1>
						<div class="clear"></div>
						<div class="left uneDynamique">'.$une.'</div>
						<div class="left">'.$articleEpingle.'</div>
						<div class="clear"></div>';
		
		$breves = '<h1>Brèves</h1>';
		$rubriquesEpinglees = obtenirListeEpingleRubrique();
		if($rubriquesEpinglees !== false)
		{
			foreach($rubriquesEpinglees as $rubriqueId)
			{
				$breves .= obtenirArticle('rubrique', $rubriqueId, 'breve', 1);
			}
		}
		$newsletter ='<h1>Newsletter</h1>
			<fieldset>
				<legend>Formulaire d\'abonnement à la newsletter</legend>
				<p class="detail">
					Abonnez-vous à la newsletter pour suivre les infos de notre site
				</p>
				<form id="newsletterFormulaire" method="POST" action="?moteur=formulaire&objet=newsletter">
					<input name="mail" type="text" placeholder="adresse email" />
					<select id="actionNewsletter" name="action">
						<option>abonnement</option>
						<option>désabonnement</option>
					</select>
					<input id="cryptogrammeNewsletter" name="cryptogramme" type="text" placeholder="cryptogramme" />
					<input type="submit" />
				</form>
			</fieldset>';
		$sectionsContent = array($debutDeLaPage, $breves, $newsletter);
		$content = obtenirContent($sectionsContent);
		echo $slider.$content;
	}
	function rubriqueMoteur($parametres = array())
	{
		$parametres = array_unique(array_map('intval', $parametres));
		$rubriqueRedirigee = obtenirRubrique("redirection", true);
		$rubriqueNormale = obtenirRubrique("redirection", false);
		$slideshow = obtenirSlideshow();
		echo obtenirSlider($rubriqueRedirigee, $slideshow, $rubriqueNormale);
		$sectionsContent = array();
		$sectionsContent = array();
		foreach($parametres as $rubId)
		{
			$sectionsContent[] = obtenirArticle('rubrique', $rubId, "liste", time());
		}
		echo obtenirContent($sectionsContent);
	}
	function articleMoteur($parametres = array())
	{
		$parametres = array_unique(array_map('intval', $parametres));
		$rubriqueRedirigee = obtenirRubrique("redirection", true);
		$rubriqueNormale = obtenirRubrique("redirection", false);
		$slideshow = obtenirSlideshow();
		$slider = obtenirSlider($rubriqueRedirigee, $slideshow, $rubriqueNormale);
		$sectionsContent = array();
		foreach($parametres as $artId)
		{
			$sectionsContent[] = obtenirArticle('id', $artId, "complet");
		}
		echo $slider.obtenirContent($sectionsContent);
	}
	function formulaireMoteur($parametres = array())
	{
		$rubriqueRedirigee = obtenirRubrique("redirection", true);
		$rubriqueNormale = obtenirRubrique("redirection", false);
		$slideshow = obtenirSlideshow();
		$slider = obtenirSlider($rubriqueRedirigee, $slideshow, $rubriqueNormale);
		$sectionsContent = array();
		if(!empty($parametres[0]) && function_exists($parametres[0].'Formulaire'))
		{
			$nomFormulaire = $parametres[0].'Formulaire';
			$sectionsContent[] = '<h1>Réponse du formulaire</h1><p>'.$nomFormulaire().'</p>';
		}
		else { $sectionsContent[] = '<h1>Réponse du formulaire</h1><p>Formulaire introuvable</p>'; }
		echo $slider.obtenirContent($sectionsContent);
	}
	function editerMoteur($parametres = array())
	{
		$objetsDisponibles = array('article', 'rubrique','personne', 'slideshow', 'meta', 'header','footer');
		$objetEdition = ((in_array($parametres[0], $objetsDisponibles))? $parametres[0]: $objetsDisponibles[0]);
		$objetEdition .= 'Edition';
		$identifiant = (empty($parametres[1]))? 'nouveau': $parametres[1];
		if(function_exists($objetEdition)) { $objetEdition($identifiant); }
		else { indexMoteur(); }
	}
	function administrationMoteur($parametres = array())
	{
		if(jeFaisPartieDuStaff())
		{
			$objetsDisponibles = array('index','article','rubrique','utilisateur', 'diffusionLettre','abonnement', 'diaporama', 'mediatheque', 'theme', 'apropos','architecture');
			$objetAdministration = ((in_array($parametres[0], $objetsDisponibles))? $parametres[0]: $objetsDisponibles[0]);
			$objetAdministration .= 'Administration';
			$identifiant = (empty($parametres[1]))? 'tous': $parametres[1];
			if(function_exists($objetAdministration))
			{
				$objetAdministration($identifiant);
				echo '<script src="js/paginationAjax.js"></script>';
			}
			else { indexMoteur(); }
		}
		else
		{
			$message = '<fieldset>
			<legend>Connectez-vous s\'il vous plait</legend>
			Vous devez être un membre de l\'équipe pour acceder à cette partie du site.
			</fieldset>';
			$content = array($message, obtenirArticle('id', 1));
			echo  obtenirContent($content);
		}
	}
	function fonctionsMoteur($parametres = array())
	{
		if(jeFaisPartieDuStaff())
		{
			$objetsDisponibles = array('liste', 'creation');
			$objetProcesseur = ((in_array($parametres[0], $objetsDisponibles))? $parametres[0]: $objetsDisponibles[0]);
			$objetProcesseur .= 'Fonctions';
			$identifiant = (empty($parametres[1]))? 'tous': $parametres[1];
			if(function_exists($objetProcesseur))
			{
				$objetProcesseur($identifiant);
				echo '<script src="js/fonctionsFonctions.js"></script>
					  <script src="js/base64.js"></script>';
			}
			else { indexMoteur(); }
		}
		else { indexMoteur(); }
	}
	function personnelMoteur($parametres = array())
	{
		$objetProcesseur = $parametres[0].'Personnelle';
		$identifiant = (empty($parametres[1]))? '': $parametres[1];
		if(function_exists($objetProcesseur))
		{
			$objetProcesseur($identifiant);
		}
		else { echo 'echec'; indexMoteur(); }
	}
	function profilMoteur($parametres = array())
	{
		$objetProcesseur = $parametres[0].'Profil';
		$identifiant = (empty($parametres[1]))? '': $parametres[1];
		if(function_exists($objetProcesseur))
		{
			$objetProcesseur($identifiant);
		}
		else { echo 'echec'; indexMoteur(); }
	}
?>