<?php
	function newsletterFormulaire()
	{
		if(jeFaisPartieDuStaff())
		{
			require('fonctionBdd.php');
			$emailSite = emailSite('consulter');
			if($_POST['action'] == 'abonnementMultiple')
			{
				if(filter_var($emailSite, FILTER_VALIDATE_EMAIL))
				{
					$_POST['date'] = date("Y-m-d H:i:s", time());
					$_POST['separation'] = ($_POST['separation'] == '')?array("\r\n", "\n", "\r"):$_POST['separation'];;
					$_POST['mail'] = str_replace($_POST['separation'], ";", $_POST['mail']);
					$_POST['mail'] = explode(';', $_POST['mail']);
					$emailRefuse = $emailAccepte = array();
					foreach($_POST['mail'] as $adresseMail)
					{
						if(filter_var($adresseMail, FILTER_VALIDATE_EMAIL))
						{
							$emailAccepte[] = $adresseMail;
						}
						else { $emailRefuse[] = $adresseMail; }
					}
					$emailDejaInscrit = $emailSucces= $doublons = array();
					$requete = 'INSERT INTO `abonnements` (`aboMail`, `aboDate`, `aboCryptogramme`)
						VALUES (:mail, :date, :cryptogramme)
						ON DUPLICATE KEY UPDATE `aboId`=`aboId`';
					$similitude = 'SELECT COUNT(*) AS `similitude` FROM `abonnements` WHERE `aboMail` = :mail';
					foreach($emailAccepte as $adresseMail)
					{
						$stmt = $bdd->prepare($similitude);
						$stmt->bindParam(':mail', $adresseMail, PDO::PARAM_STR);
						$stmt->execute();
						$row = $stmt->fetch(PDO::FETCH_OBJ);
						if($row->similitude) { $doublons[] = $adresseMail; }
						else
						{
							$_POST['cryptogramme'] = md5($adresseMail.$_POST['date']);
							$stmt = $bdd->prepare($requete);
							$stmt->bindParam(':mail', $adresseMail, PDO::PARAM_STR);
							$stmt->bindParam(':date', $_POST['date'], PDO::PARAM_STR);
							$stmt->bindParam(':cryptogramme', $_POST['cryptogramme'], PDO::PARAM_STR);
							if($stmt->execute())
							{
								$emailSucces[] = $adresseMail;
								$subject = 'Lettre d\'information de '.$_SERVER['SERVER_NAME'];
								$message = '<html><head> <title>'.$subject.'</title></head>
												<body>
												  <p>Bienvenue sur la lettre d\'information de '.$_SERVER['SERVER_NAME'].'</p>
												  <p>
													Votre adresse e-mail '.$adresseMail.' vient d\'être ajoutée à notre liste de diffusion.<br />
													Vous recevrez désormais nos lettres d\'information.
												  </p>
												  <p>
													Pour supprimer cet abonnement il suffit de remplir le formulaire de désinscription sur notre site et de saisir ce code confidentiel: <b>'.$_POST['cryptogramme'].'</b> dans le champs nommé cryptogramme<br />
													Vous pouvez aussi nous contacter par e-mail à l\'adresse suivante: '.$emailSite.'
												  </p>
												  <p>
												  
												  Merci et à bientôt sur <a href="'.$_SERVER['SERVER_NAME'].'">'.$_SERVER['SERVER_NAME'].'</a></p>
												</body>
											</html>';
								$headers  = 'MIME-Version: 1.0' . "\r\n";
								$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
								$headers .= 'To: '.$adresseMail.' <'.$adresseMail.'>'."\r\n";
								$headers .= 'From: <'.$emailSite.'>' . "\r\n";
								mail($adresseMail, $subject, $message, $headers);
							}
							else
							{
								$emailRefuse[] = $adresseMail;
							}
						}
					}
					if(count($doublons) > 0)
					{
						$messageDoublons = 'Les éléments suivants ont été ignorés d\'office car ils figuraient déjà dans la liste de diffusion: <b><i>'.implode(', ',$doublons).'</i></b>';
					}
					else { $messageDoublons = ''; }
					if(count($emailRefuse) == 0)
					{
						$message = $messageDoublons.'<br />La liste a été ajoutée avec succes .<br />
						<a href="?moteur=administration&objet=index">Revenir à l\'administration</a><br />
						<a href="?moteur=administration&objet=abonnement">Gestion des abonnements</a>';
					}
					else
					{
						$message =  $messageDoublons.'<br />La liste a été ajouté mais les éléments suivants:<b><i>'.implode(', ',$emailRefuse).'</i></b>';
					}
				}
				else
				{
					$message = 'Vous ne pouvez pas ajouter d\'abonnement tant que vous n\'avez pas défini d\'adresse email valide pour le site.';
				}
				return $message; 
			}
			else
			{
				$erreurs = array();
				$_POST['mail'] = (empty($_POST['mail']))? '' : $_POST['mail'] ;
				$_POST['cryptogramme'] = (empty($_POST['cryptogramme']))? '' : $_POST['cryptogramme'];
				if(filter_var($_POST['mail'], FILTER_VALIDATE_EMAIL))
				{
					require('fonctionBdd.php');
					$requete = 'SELECT * FROM `abonnements` WHERE `aboMail` = :mail';
					$stmt = $bdd->prepare($requete);
					$stmt->bindParam(':mail', $_POST['mail'], PDO::PARAM_STR);
					$stmt->execute();
					$abonnementSimilaire = $stmt->rowCount();
					if($_POST['action'] == 'abonnement')
					{
						if($abonnementSimilaire > 0)
						{
							$erreurs[] = 'Impossible d\'ajouter '. $_POST['mail'] .' à la lettre d\'information';
						}
						else
						{
							$_POST['date'] = date("Y-m-d H:i:s", time());
							$_POST['cryptogramme'] = md5($_POST['mail'].$_POST['date']);
							$requete = 'INSERT INTO `abonnements` (`aboMail`, `aboDate`, `aboCryptogramme`)
							VALUES (:mail, :date, :cryptogramme)';
							$stmt = $bdd->prepare($requete);
							$stmt->bindParam(':mail', $_POST['mail'], PDO::PARAM_STR);
							$stmt->bindParam(':date', $_POST['date'], PDO::PARAM_STR);
							$stmt->bindParam(':cryptogramme', $_POST['cryptogramme'], PDO::PARAM_STR);
							$stmt->execute();
							$messageSucces = 'Opération effectuée avec succès. La procédure de désinscription a été envoyé sur votre boite mail: '.$_POST['mail'];
							// envoyer procedre de d'abonnement par email
							$subject = 'Lettre d\'information de '.$_SERVER['SERVER_NAME'];
							$message = '<html><head> <title>'.$subject.'</title></head>
												<body>
												  <p>Bienvenue sur la lettre d\'information de '.$_SERVER['SERVER_NAME'].'</p>
												  <p>
													Votre adresse e-mail '.$adresseMail.' vient d\'être ajoutée à notre liste de diffusion.<br />
													Vous recevrez désormais nos lettres d\'information.
												  </p>
												  <p>
													Pour supprimer cet abonnement il suffit de remplir le formulaire de désinscription sur notre site et de saisir ce code confidentiel: <b>'.$_POST['cryptogramme'].'</b> dans le champs nommé cryptogramme<br />
													Vous pouvez aussi nous contacter par e-mail à l\'adresse suivante: '.$emailSite.'
												  </p>
												  <p>
												  
												  Merci et à bientôt sur <a href="'.$_SERVER['SERVER_NAME'].'">'.$_SERVER['SERVER_NAME'].'</a></p>
												</body>
											</html>';
							$headers  = 'MIME-Version: 1.0' . "\r\n";
							$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
							// Additional headers
							$headers .= 'To: '.$_POST['mail'].' <'.$_POST['mail'].'>'."\r\n";
							$headers .= 'From: <'.$emailSite.'>' . "\r\n";
							mail($_POST['mail'], $subject, $message, $headers);
						}
					}
					else
					{
						if($abonnementSimilaire < 1)
						{
							$erreurs[] = 'Impossible d\'annuler l\'abonnement de '.  $_POST['mail'] .'';
						}
						else
						{
							$requete = 'DELETE FROM `abonnements` WHERE `aboMail` = :mail AND `aboCryptogramme` = :cryptogramme';
							$stmt = $bdd->prepare($requete);
							$stmt->bindParam(':mail', $_POST['mail'], PDO::PARAM_STR);
							$stmt->bindParam(':cryptogramme', $_POST['cryptogramme'], PDO::PARAM_STR);
							$stmt->execute();
							if($stmt->rowCount() > 0)
							{
								$messageSucces = 'Opération effectuée avec succès. '. $_POST['mail'] .' ne recevra plus nos lettres d\'informations';
								$subject = 'Lettre d\'information de '.$_SERVER['SERVER_NAME'];
								$message = '<html><head> <title>'.$subject.'</title></head>
												<body>
												  <p>Bonjour,</p>
												  <p>
													Suite à votre demande ou à celle d\'un administrateur du site '.$_SERVER['SERVER_NAME'].', votre adresse email a été retiré de notre liste de diffusion.<br />
													Vous ne recevrez nos lettres d\'information.
												  </p>
												  <p>
													Merci d\'avoir suivi notre lettre d\'information. Nous espérons vous revoir bientôt tout de même.
												  </p>
												</body>
											</html>';
								$headers  = 'MIME-Version: 1.0' . "\r\n";
								$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
								// Additional headers
								$headers .= 'To: '.$_POST['mail'].' <'.$_POST['mail'].'>'."\r\n";
								$headers .= 'From: <'.$emailSite.'>' . "\r\n";
								mail($_POST['mail'], $subject, $message, $headers);
							}
							else
							{
								$erreurs[] = 'Impossible d\'annuler l\'abonnement de '. $_POST['mail'] .' avec ce cryptogramme. Retrouvez le bon cryptogramme dans l\'email que vous aviez reçu en vous inscrivant (le cas échéant, contactez un administrateur en utilisant cette adresse email:'. $_POST['mail'] .').';
							}
						}
					}
				}
				else
				{
					$erreurs[] = 'Veuillez renseigner une adresse mail valide.';
				}
				if(count($erreurs)>0)
				{
					$alerte = implode('<br />', $erreurs);
					$alerte .= '<br /><a id="pagePrecedente"></a>';
				}
				else { $alerte = $messageSucces; }
				return $alerte;
			}
		}
		else
		{
			return 'Vous ne disposez pas de droits suffisants pour utliser la lettre d\'information du site.
			<a id="pagePrecedente"></a>
			<a href="?moteur=index">Cliquez ici pour revenir à la page d\'accueil du site public</a><br />
			<a href="?moteur=adminitration&objet=index">Cliquez ici pour revenir sur l\'accueil d\'administration</a>';
		}
	}
	function diaporamaFormulaire($id="")
	{
		if(jeSuisAdmin() || jeSuisRedacteur())
		{
			require('fonctionBdd.php');
			$resultat = '';
			$_POST['ajout'] = (empty($_POST['ajout']))?'local':$_POST['ajout'];
			$_POST['titre'] = (empty($_POST['titre']))?'sans titre '.date('d-m-Y',time()): strip_tags($_POST['titre']);
			$_POST['affiche'] = (empty($_POST['affiche']))?0:min(max(0,intval($_POST['affiche'])),1);
			if($_POST['ajout'] == 'local')
			{
				if(empty($_FILES['fichier']) || $_FILES['fichier']['name'] == '')
				{
					$resultat = 'Vous devez choisir un fichier.<br /><a id="pagePrecedente"></a>';
				}
				else
				{
					$unite = 1048576; // 1 Mo convertit en octect
					if(!is_dir('diaporama/')) { mkdir('diaporama',0777); }
					$reglePhotos = array( "tailleMax" => (1.5*$unite), "tailleMin" => (0.01*$unite), "repertoire" => 'diaporama/');
					$reglesFichiers = array('jpeg' => $reglePhotos,'jpg' => $reglePhotos,'gif' => $reglePhotos,'png' => $reglePhotos,'svg' => $reglePhotos,);
					$_FILES['fichier']['name'] = str_replace(' ','-', $_FILES['fichier']['name']);
					$ext = substr(strrchr($_FILES['fichier']["name"],'.'),1);
					if(array_key_exists($ext, $reglesFichiers))
					{
						$regleUpload = $reglesFichiers[$ext];
						if($_FILES['fichier']['size'] < $regleUpload['tailleMin'] || $_FILES['fichier']['size'] > $regleUpload['tailleMax'] )
						{
							$resultat .= 'Désolé, la taille de votre fichier doit être comprise entre '. ($regleUpload['tailleMin']/$unite).' Mo et '. ($regleUpload['tailleMax']/$unite) .' Mo.<br />
							Votre fichier pèse actuellement '. round(($_FILES['fichier']['size']/$unite),3) .' Mo.<br />
							<a id="pagePrecedente"></a>
							<a href="?moteur=administration&objet=index">Revenir à l\'index d\'administration</a>';
						}
						else
						{	
							if(file_exists($regleUpload['repertoire'].$_FILES['fichier']['name']))
							{
								$resultat = 'Désolé, un fichier nommé <b>'. $_FILES['fichier']['name'] .'</b> existe déjà. Renommez votre fichier et renvoyez-le à nouveau.<br />
								<a id="pagePrecedente"></a>';
							}
							else
							{
								if(move_uploaded_file($_FILES['fichier']['tmp_name'], $regleUpload['repertoire'].$_FILES['fichier']['name']))  
								{
									$resultat .= insererSlideshow($_POST['titre'],$_FILES['fichier']['name'], 1, $_POST['affiche']);
								}
								else
								{
									$resultat .= 'Une erreur inconnue est survenue lors du téléchargement du fichier.';
								}
							}
						}
					}
					else
					{
						$resultat .= 'Désolé, seules les extensions '.implode(', ', array_keys($reglesFichiers)).' sont acceptées.';
					}
					$resultat .= ($_FILES['fichier']['error'] == 0)? '': $_FILES['fichier']['error'];
				}
			}
			else
			{
				if(filter_var($_POST['url'], FILTER_VALIDATE_URL))
				{
					$resultat .= insererSlideshow($_POST['titre'], $_POST['url'], 0, $_POST['affiche']);
				}
				else
				{
					$resultat .= $_POST['url'].' n\est pas une URL acceptable.
					<a id="pagePrecedente"></a>';
				}
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de droits suffisants pour modifier le diaporama.
			<a id="pagePrecedente"></a>
			<a href="?moteur=index">Cliquez ici pour revenir à la page d\'accueil du site public</a><br />
			<a href="?moteur=adminitration&objet=index">Cliquez ici pour revenir sur l\'accueil d\'administration</a>';
		}
		return $resultat;
	}
	function diffusionLettreFormulaire($id="")
	{
		if(jeFaisPartieDuStaff())
		{
			$err = array();
			if(empty($_POST['titre'])) { $err[] = '<li>Veuillez remplir le champ titre</li>'; }
			else
			{
				$_POST['titre'] = strip_tags($_POST['titre']);
				if(strlen($_POST['titre']) < 9)
				{
					$err[] = '<li>Votre titre est trop court ('.strlen($_POST['titre']).' caractères). Il doit faire au moins 10 caractères</li>';
				}
			}
			if(empty($_POST['message'])) { $err[] = '<li>Veuillez remplir le champ message</li>'; }
			elseif(strlen($_POST['titre']) < 100)
			{
				$err[] = '<li>Votre message est trop court ('.strlen($_POST['message']).' caractères). Il doit faire au moins 100 caractères</li>';
			}
			$retourEnSauvegarde = '<form method="POST" action="?moteur=administration&objet=diffusionLettre">
								<input type="hidden" name="titre" value="'.$_POST['titre'].'"/>
								<input type="hidden" name="message" value="'.$_POST['message'].'"/>
								<input type="submit" value="Modifier mon email"/>
							</form>
							<hr />
							<a href="?moteur=administration&objet=diffusionLettre">Recommencer l\'édition de la lettre à zéro</a><br />
							<a href="?moteur=administration&objet=index">Revenir à l\'administration</a>';
			if(count($err) == 0)
			{
				require('fonctionBdd.php');
				$requete = 'SELECT * FROM `abonnements`';
				$stmt = $bdd->prepare($requete);
				if($stmt->execute())
				{
					$listeEmail = '';
					while($row = $stmt->fetch(PDO::FETCH_OBJ))
					{
						$listeEmail .= $row->abomail.', ';
					}
					$listeEmail = substr($listeEmail,0,-2);// suppression du ', ' en trop.
					$headers  = 'MIME-Version: 1.0' . "\r\n";
					$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
					$headers .= 'Bcc: '.$listeEmail. "\r\n";
					$headers .= 'From: <'.$emailSite.'>' . "\r\n";
					mail($emailSite, $_POST['titre'], $_POST['message'], $headers);
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					$resultat = '<fieldset>
									<legend><h4>Des erreurs ont été detectées</h4></legend>
									Une erreur SQL esurvenue: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2].'
									<br />'.$retourEnSauvegarde.'<hr />
									<a href="?moteur=administration&objet=diffusionLettre">Recommencer l\'édition de la lettre à zéro</a><br />
									<a href="?moteur=administration&objet=index">Revenir à l\'administration</a>
								</fieldset>';
				}
				$resultat = 'envoie de l\'email';
			}
			else
			{
				$resultat = '<fieldset>
								<legend><h4>Des erreurs ont été détectées</h4></legend>
								<ul>'.implode('',$err).'</ul>
								'.$retourEnSauvegarde.'
							</fieldset>';
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de droits suffisants pour envoyer des lettres d\'informations.
			<a id="pagePrecedente"></a>
			<a href="?moteur=index">Cliquez ici pour revenir à la page d\'accueil du site public</a><br />
			<a href="?moteur=administration&objet=index">Cliquez ici pour revenir sur l\'accueil d\'administration</a>';
		}
		return $resultat;
	}
	function epinglerArticleFormulaire()
	{
		if(jeSuisAdmin() || jeSuisRedacteur())
		{
			if(empty($_POST['id']))
			{
				$resultat = 'Vous devez sélectionner un article';
			}
			else
			{
				if($_POST['id'] === 'aucun')
				{
					$desinpinglement = desepinglerArticle();
					$resultat = ($desinpinglement === true)?'Toutes épingles ont été retirées avec succès':$desinpinglement.'<a id="pagePrecedente"></a>';
				}
				else
				{
					$epinglement = epinglerArticle(intval($_POST['id']));
					$resultat = ($epinglement === true)?'L\'article '.$_POST['id'].' a été épinglé avec succès.':$epinglement.'<a id="pagePrecedente"></a>';
				}
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de droits suffisants pour envoyer des lettres d\'informations.
			<a id="pagePrecedente"></a>';
		}
		return $resultat.'<br />
		<a href="?moteur=administration&objet=index">Aller sur la page d\'administration</a>
		<a href="?moteur=administration&objet=architecture">Revenir sur l\'architecture du site</a>';
	}
	function ajouterThemeFormulaire()
	{
		if(jeSuisAdmin())
		{
			$unite = 1048576; // 1 Mo convertit en octect
			$regleTheme = array( "tailleMax" => (3*$unite), "tailleMin" => (0), "repertoire" => 'style/theme/');
			$reglesFichiers = array('zip' => $regleTheme);
			$_FILES['theme']['name'] = str_replace(' ','-', $_FILES['theme']['name']);
			$ext = substr(strrchr($_FILES['theme']["name"],'.'),1);
			if(array_key_exists($ext, $reglesFichiers))
			{
				$regleUpload = $reglesFichiers[$ext];
				if($_FILES['theme']['size'] < $regleUpload['tailleMin'] || $_FILES['theme']['size'] > $regleUpload['tailleMax'] )
				{
					$resultat .= 'Désolé, la taille de votre thème doit être comprise entre '. ($regleUpload['tailleMin']/$unite).' Mo et '. ($regleUpload['tailleMax']/$unite) .' Mo.<br />
					Votre thème pèse actuellement '. round(($_FILES['theme']['size']/$unite),3) .' Mo.';
				}
				else
				{
					if(file_exists($regleUpload['repertoire'].$_FILES['theme']['name']))
					{
						$resultat = 'Désolé, un fichier nommé <b>'. $_FILES['theme']['name'] .'</b>. Renommez votre fichier et renvoyez-le à nouveau.<br />
						<a id="pagePrecedente"></a>';
					}
					else
					{
						$nomTemporairePendantEvaluation ='upload_'.time().'_'.$_FILES['theme']['name'];
						if(move_uploaded_file($_FILES['theme']['tmp_name'],'style/'.$nomTemporairePendantEvaluation))
						{
							preparerCorbeille('style/'.$nomTemporairePendantEvaluation);
							$zip = new ZipArchive;
							if ($zip->open('style/'.$nomTemporairePendantEvaluation) !== true)
							{
								$resultat = 'Impossible d\'ouvrir l\'archive de votre thème';
							}
							else
							{
								$nomTheme = ($zip->extractTo('style/', array('nom.txt')))?strip_tags(file_get_contents('style/nom.txt')):false;
								$dossierTheme = ($zip->extractTo('style/', array('dossier.txt')))?strip_tags(file_get_contents('style/dossier.txt')):false;
								$informationsTheme = ($zip->extractTo('style/', array('informations.txt')))?strip_tags(file_get_contents('style/informations.txt')):false;
								if($nomTheme !== false) {preparerCorbeille('style/nom.txt',(-5*60));}
								if($dossierTheme !== false) {preparerCorbeille('style/dossier.txt',(-5*60));}
								if($informationsTheme !== false) {preparerCorbeille('style/informations.txt',(-5*60));}
								if($nomTheme === false || $dossierTheme === false || $informationsTheme === false)
								{
									$resultat = 'Le ou les fichiers suivant(s) manque(nt) à votre thème afin qu\'il soit installé:
									<ul>
										'. (($nomTheme === false)?'<li>nom.txt</li>':'').'
										'. (($nomTheme === false)?'<lidossier.txt</li>':'').'
										'. (($nomTheme === false)?'<li>informations.txt</li>':'').'
									</ul>';
								}
								if(strlen($nomTheme)<3 || strlen($dossierTheme)<3)
								{
									$resultat = 'Le nom du thème ou le nom du dossier doivent contenir au mois 3 caractères pour que le thème soit installé.';
								}
								else
								{
									if(is_dir('style/theme/'.$nomTemporairePendantEvaluation))
									{
										$resultat = 'Un thème utilise déjà le dossier <b><i>'.$dossierTheme.'</i></b>';
									}
									else
									{
										$repFinal = 'style/theme/'.$dossierTheme; // notez qu'il n'y a pas de "/" à la fin.
										$dossier = mkdir($repFinal,0777);
										$zip->extractTo($repFinal.'/');
										$resultat = ajouterTheme($nomTheme,$dossierTheme,$informationsTheme);
										$fichiersInterdits = array('index.php','index.html','.htaccess');
										foreach($fichiersInterdits as $element)
										{
											if(file_exists($repFinal.'/'.$element))
											{
												unlink($repFinal.'/'.$element);
											}
										}
									}
								}
								$zip->close();
							}
						}
						else
						{
							$resultat = 'Une erreur inconnue est survenue lors du téléchargement du fichier.';
						}
					}
				}
			}
			else
			{
				$resultat = 'Désolé le format '.$ext.' n\'est pas accepté. Veuillez placer les fichiers de votre thème dans une archive zip';
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas de droits suffisants pour ajouter des thèmes sur le site.
			<a id="pagePrecedente"></a>';
		}
		return $resultat.'
		<a href="?moteur=administration&objet=index">Aller à l\'index d\'administration</a>
		<a href="?moteur=administration&objet=theme">Revenir sur la gestion des thème</a>';
	}
	
	
	
	
	
	
	
	
	
	
?>