<?php
	function listeFonctions()
	{
		if(jeFaisPartieDuStaff())
		{
			$fonctionsPersonnelles = obtenirFonctions('php/fonctionsPersonnelles.php');
			$fonctionsFormulaire = obtenirFonctions('php/fonctionsFormulaires.php');
			$listeFonctionsPersonnelles = $listeFonctionsFormulaire = array();
			foreach($fonctionsPersonnelles as $fonction)
			{
				$fonctionDetaillee = explode('(', $fonction);
				$nom = str_replace('Personnelle','',$fonctionDetaillee[0]);
				$arguments = base64_encode($fonctionDetaillee[1]);
				$instructions = base64_encode(obtenirInstructionFonctions($nom,'php/fonctionsPersonnelles.php'));
				$listeFonctionsPersonnelles[] = array('nom' => $nom, 'arguments' => $arguments, 'instructions' => $instructions);
			}
			$optionsFonctionsPersonnelles ='';
			foreach($listeFonctionsPersonnelles as $fonction)
			{
				$optionsFonctionsPersonnelles .= '<option value="'.$fonction['nom'].'" data-arguments="'.$fonction['arguments'].'" data-instructions="'.$fonction['instructions'].'">'.$fonction['nom'].'</option>';
			}
			foreach($fonctionsFormulaire as $fonction)
			{
				$fonctionDetaillee = explode('(', $fonction);
				$nom = str_replace('Formulaire','',$fonctionDetaillee[0]);
				$arguments =  base64_encode($fonctionDetaillee[1]);
				$instructions = base64_encode(obtenirInstructionFonctions($nom,'php/fonctionsFormulaires.php'));
				$listeFonctionsFormulaire[] = array('nom' => $nom, 'arguments' => $arguments, 'instructions' => $instructions);
			}
			$optionsFonctionsFormulaire ='';
			foreach($listeFonctionsFormulaire as $fonction)
			{
				$optionsFonctionsFormulaire .= '<option value="'.$fonction['nom'].'" data-arguments="'.$fonction['arguments'].'" data-instructions="'.$fonction['instructions'].'">'.$fonction['nom'].'</option>';
			}
			
			$mesFonctions = mesFonctionsFonctions();
			$librairies = $optionSelectLibrairie = array();
			foreach($mesFonctions as $key => $fonctions)
			{
				$optionSelectLibrairie[] = '<option value="librairie'.$key.'">'.$key.'</option>';
				$librairies[$key] = '<fieldset class="librairie" id="librairie'.$key.'">
					<legend>'. $key .'</legend>
					'. implode('<br />', $fonctions).'
				</fieldset>';
			}
			$resultat = menuAdministration().'
				
				<fieldset class="zoneAdministration">
					<legend><h2>Gestionnaire avancé</h2></legend>
					<table style="max-width:55em;">
						<tr>
							<td style="vertical-align:top;">
								<fieldset style="width:35.5em;">
									<legend><h4>Mise en garde</h4></legend>
									<p class="detail">
										N\'utilisez ce formulaire que si vous avez de très bonnes connaissances en programmation PHP.<br />
										La moindre erreur de votre part peut détruire le logiciel.<br />
										La puissance de cet outil est tel qu\'il peut désactiver toutes les fonctions de sécurité.
									</p>
								</fieldset>
								<fieldset style="width:35.5em;">
									<legend><h4>Gestionnaire des fonctions personnelles</h4></legend>
									<form method="POST" action="?moteur=formulaire&objet=modifierFonction">
										<table >
											<tr>
												<th>Nom</th><th>Arguments</th>
											<tr>
											<tr>
												<td style="vertical-align:top;">
													<select class="choixFonctionPersonnelle"  name="nom">
													<option selected="selected" disabled>Faites une selection</option>
														'.$optionsFonctionsPersonnelles.'
													</select>
													<input type="hidden" name="gestionnaire" value="Personnelle" />
												</td>
												<td class="detail">
													<input class="inputArgumentsPersonnel detail" style="width:25em;" max-width:90%; type="text" name="arguments" value="" />
												</td>
											</tr>
											<tr><th colspan="2">Insctructions</th></tr>
											<tr>
												<td colspan="2">
													<textarea class="instructionsFonctionPersonnelle detail" style="width:100%; max-width:40em; min-height:10em;" name="instructions"></textarea>
												</td>
											</tr>
											<tr>
												<td colspan="2" class="resultatFonctionPersonnelle"></td>
											</tr>
											<tr>
												<td colspan="2">
													<input type="button" class="verifierFonction" value="Verifier la fonction" data-nom="choixFonctionPersonnelle" data-arguments="inputArgumentsPersonnel" data-instructions="instructionsFonctionPersonnelle" data-resultat="resultatFonctionPersonnelle" />
													<input type="submit" value="Enregistrer les modifications">
												</td>
											</tr>
										</table>
									</form>
								</fieldset>
								<fieldset  style="width:35.5em;">
									<legend><h4>Gestionnaire des formulaires</h4></legend>
									<form method="POST" action="?moteur=formulaire&objet=modifierFonction">
									<table>
										<tr>
											<th>Nom</th><th>Arguments</th>
										<tr>
										<tr>
											<td>
												<select class="choixFonctionFormulaire" name="nom">
													<option selected="selected" disabled>Faites une selection</option>
													'.$optionsFonctionsFormulaire.'
												</select>
												<input type="hidden" name="gestionnaire" value="Formulaire" />
											</td>
											<td class="detail">
												<input class="inputArgumentsFormulaire detail" type="text" style="width:25em;" max-width:90%; type="text" name="arguments" value="" />
											</td>
										</tr>
										<tr><th colspan="2">Instructions</th></tr>
										<tr>
											<td colspan="2">
												<textarea class="instructionsFonctionFormulaire detail" style="width:100%; min-height:10em;" name="instructions"></textarea>
											</td>
										</tr>
										<tr>
											<td colspan="2" class="resultatFonctionFormulaire"></td>
										</tr>
										<tr>
											<td colspan="2">
												<input type="button" class="verifierFonction" value="Verifier la fonction" data-nom="choixFonctionFormulaire" data-arguments="inputArgumentsFormulaire" data-instructions="instructionsFonctionFormulaire" data-resultat="resultatFonctionFormulaire" />
												<input type="submit" value="Valider la fonction">
											</td>
										</tr>
									</table>
									</form>
								</fieldset>
							</td>
							<td style="vertical-align:top;">
								<fieldset style="max-height:50em; overflow:auto; width:100%;">
									<legend><h4>Librairie de fonctions</h4></legend>
									<div class="detail">
										<select id="selectLibrairies">
											<option selected="selected" disabled>Choisissez un gestionnaire</option>
											'.implode('<br />', $optionSelectLibrairie).'
										</select>
										'.implode('', $librairies).'
									</detail>
								</fieldset>
							</td>
						</tr>
					</table>
				</fieldset>';
		}
		else
		{
			$resultat = 'Vous ne disposez pas de suffisament de droits pour consulter la liste des processeurs.
			<a id="pagePrecedente"></a>
			<a href="?moteur=index">Revenir sur la page d\'accueil du site</a>';
		}
		echo $resultat;
	}
	function obtenirFonctions($fichier)
	{
		$resultat = array();
		if(jeFaisPartieDuStaff())
		{
			if(file_exists($fichier))
			{
				preg_match_all('#(function)(.*)\)#U', file_get_contents($fichier), $listeDesFonctions);
				foreach($listeDesFonctions[2] as $concordance)
				{
					$fonctions[] = trim($concordance);
				}
				natcasesort($fonctions);
				$resultat = $fonctions;
			}
		}
		else
		{
			$resultat[] = 'Vous ne disposez pas de suffisament de droits pour consulter la liste des processeurs.
			<a id="pagePrecedente"></a>';
		}
		return $resultat;
	}
	function obtenirInstructionFonctions($nom, $fichier)
	{
		$fichier = file_exists($fichier)?$fichier:'php/fonctionsPersonnelles.php';
		$contenu = stristr(file_get_contents($fichier), $nom);
		if($contenu !== false)
		{
			$contenu = stristr($contenu, $nom);
			$contenu = explode('function', $contenu);
			$contenu = $contenu[0];
			$contenu = stristr($contenu, '{');
			$resultat = utf8_decode(substr($contenu, 1, (strrpos($contenu, '}')-1)));
		}
		else
		{
			$resultat = 'La fonction '.$nom.' n\'a pas été trouvé dans '.basename($fichier).'';
		}
		return $resultat;
	}
	function creationFonctions($nom="")
	{
		if(jeSuisAdmin())
		{
			$mesFonctions = mesFonctionsFonctions();
			$librairies = $optionSelectLibrairie = array();
			foreach($mesFonctions as $key => $fonctions)
			{
				$optionSelectLibrairie[] = '<option value="librairie'.$key.'">'.$key.'</option>';
				$librairies[$key] = '<fieldset class="librairie" id="librairie'.$key.'">
					<legend>'. $key .'</legend>
					'. implode('<br />', $fonctions).'
				</fieldset>';
			}
			$resultat = menuAdministration().'
			<fieldset class="zoneAdministration">
				<legend><h2>Ajouter une fonction</h2></legend>
				<fieldset>
					<legend><h4>Mise en garde</h4></legend>
					<p>
						N\'utilisez ce formulaire que si vous avez de très bonnes connaissances en programmation PHP.<br />
						La moindre erreur de votre part peut détruire le logiciel.<br />
						La puissance de cet outil est tel qu\'il peut désactiver toutes les fonctions de sécurité.
					</p>
				</fieldset>
				<fieldset>
					<legend><h4>Formulaire d\'ajout</h4></legend>
					<form method="POST"  action="?moteur=formulaire&objet=creationFonction">
						<table>
							<tr>
								<th>Nom</th><th>Arguments</th><th>Librairie</th>
							</tr>
							<tr>
								<td style="width:10em; text-align:center;">
									<input type="text" class="nomFonctionFormulaire" name="nom" style="width:80%;" placeholder="helloWorld" />
								</td>
								<td><input type="text" class="argumentsFonctionFormulaire" name="arguments" style="min-width:20em;" placeholder="$message=\'Hello World !!!\', $auteur=\''.$_SESSION['utilisateur']['nom'].' '.$_SESSION['utilisateur']['prenom'].'\'" /></td>
								<td rowspan="4" style="vertical-align:top;">
									<fieldset style="max-height:50em; overflow:auto; width:100%;">
										<legend><h4>Librairie de fonctions</h4></legend>
										<div class="detail">
											<select id="selectLibrairies">
												<option selected="selected" disabled>Choisissez un gestionnaire</option>
												'.implode('<br />', $optionSelectLibrairie).'
											</select>
											'.implode('', $librairies).'
										</detail>
									</fieldset>
								</td>
							</tr>
							<tr>
								<th colspan="2">Description</th>
							</tr>
							<tr>
								<td colspan="2">
									<textarea class="instructionsFonctionFormulaire" name="instructions" style="width:45em; height:15em;" placeholder="return $auteur.\' a dit \'.$message;"></textarea><br />
								</td>
							</tr>
							<tr>
								<th>Choix du gestionnaire</th>
								<th>Verification et validation</th>
							</tr>
							<tr>
								<td colspan="2" class="resultatFonctionFormulaire"></td>
							</tr>
							<tr>
								<td>
									<select name="gestionnaire">
										<option selected="selected" disabled>Veuillez faire un choix</option>
										<option value="Personnelle">Gestionnaire personnel</option>
										<option value="Formulaire">Gestionnaire de formulaire</option>
									</select>
								</td>
								<td>
									<input type="button" class="verifierFonction" value="Verifier la fonction" data-nom="nomFonctionFormulaire" data-arguments="argumentsFonctionFormulaire" data-instructions="instructionsFonctionFormulaire" data-resultat="resultatFonctionFormulaire" />
									<input type="submit" value="Créer la fonction" />
								</td>
							</tr>
						</table>
					</form>
				</fieldset>
			</fieldset>';
		}
		else
		{
			$resultat = 'Vous ne disposez pas de suffisament de droits pour consulter la liste des processeurs.
			<a id="pagePrecedente"></a>
			<a href="?moteur=index">Revenir sur la page d\'accueil du site</a>';
		}
		echo $resultat;
	}
	
	function mesFonctionsFonctions()
	{
		$mesFonctions = array();
		$fonctionsDefinies = get_defined_functions();
		asort($fonctionsDefinies['user']);
		$gestionnairesConnus = array('Administration',
									'Article',
									'Content',
									'Corbeille',
									'Edition',
									'Formulaire',
									'Mediatheque',
									'Personnelle',
									'Rubrique',
									'Moteur',
									'Theme',
									'Slideshow');
		foreach ($fonctionsDefinies['user'] as $fonction)
		{
			$fonction = new ReflectionFunction($fonction);
			$gestionnaireFonction = couperSurLesMajuscules($fonction->name);
			$gestionnaireFonction = $gestionnaireFonction[count($gestionnaireFonction)-1];
			if(!in_array($gestionnaireFonction, $gestionnairesConnus))
			{
				$gestionnaireFonction = 'Inclassable';
			}
			if(array_key_exists($gestionnaireFonction, $mesFonctions))
			{
				$mesFonctions[$gestionnaireFonction][] = $fonction->name; 
			}
			else
			{
				$mesFonctions[$gestionnaireFonction] = array($fonction->name);
			}
		}
		ksort($mesFonctions);
		return $mesFonctions;
	}
	
	function verifierFonction($fichier, $nom, $arguments, $instructions)
	{
		$nom = base64_decode($nom);
		$arguments = base64_decode($arguments);
		$instructions = base64_decode($instructions);
		$messageSucces = 'Aucune erreur syntaxique trouvée';
		$fonction = '<?php
	function '.$nom.' ('.$arguments.')'.'
	{
		'.$instructions.'
	}
	echo \''.$messageSucces.'\'; 
?>';
		$fp = fopen($fichier,'w+');
		fwrite($fp,$fonction);
		fclose($fp);
		$resultat = include($fichier);
		return $resultat;
	}
?>