<?php
	function rubriqueEdition($id)
	{
		if(jeSuisAdmin() || jeSuisRedacteur() )
		{
			require('fonctionBdd.php');
			$requete = 'SELECT * FROM `articles` ORDER BY `artTitre`';
			$stmt = $bdd->prepare($requete);
			if($stmt->execute())
			{
				$listeArticle = '';
				while($row = $stmt->fetch(PDO::FETCH_OBJ))
				{
					$listeArticle .= '<option value="'.$row->artId.'">'.$row->artTitre.'</option>';
				}
			}
			else
			{
				$codeErreur = $stmt->errorInfo();
				$resultat = 'Une erreur est survenue. Code erreur SQL: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2];
			}
			$requete = 'SELECT * FROM `rubriques` WHERE `rubId` = '.intval($id);
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$resultat ='<fieldset class="articleEdition">
								<legend><h2>Modifier la rubrique '. $row->rubId .'</h2></legend>
								<form method="POST" action="?moteur=formulaire&objet=rubrique">
									<input type="hidden" name="rubriqueId" value="'.$row->rubId.'"/>
									<table>
										<tr>
											<th>Nom</th>
											<td><input type="text" name="rubriqueNom" value="'.$row->rubNom.'" placeholder="nom de la rubrique" /></td>
										</tr>
										<tr>
											<th>Article de<br />référence:</th>
											<td><select name="rubriqueArticle">'. str_replace('value="'.$row->rubArticle.'"','value="'.$row->rubArticle.'" selected="selected"', $listeArticle) .'</select></td>
										</tr>
										<tr>
											<td colspan="2"><input type="checkbox" name="rubriqueRedirection" value="1" '.(($row->rubRedirection)?'checked':'').'/>Activer la redirection vers l\'article de référence.</td>
										</tr>
										<tr>
											<td colspan="2"><input type="submit" value="Modifier la rubrique"/></td>
										</tr>
									</table>
								</form>
							</fieldset>';
			}
			else
			{
				$resultat ='<fieldset class="articleEdition">
								<legend><h2>Créer une nouvelle rubrique</h2></legend>
								<form method="POST" action="?moteur=formulaire&objet=rubrique">
									<input type="hidden" name="rubriqueId" value="nouveau"/>
									<table>
										<tr>
											<th>Nom</th>
											<td><input type="text" name="rubriqueNom" value="Sans nom" placeholder="nom de la rubrique" /></td>
										</tr>
										<tr>
											<th>Article de<br />référence:</th>
											<td><select name="rubriqueArticle">'. $listeArticle .'</select></td>
										</tr>
										<tr>
											<td colspan="2"><input type="checkbox" name="rubriqueRedirection" value="1" />Activer la redirection vers l\'article de référence.</td>
										</tr>
										<tr>
											<td colspan="2"><input type="submit" value="Créer cette rubrique"/></td>
										</tr>
									</table>
								</form>
							</fieldset>';
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas des droits suffisants pour acceder à cette partie du site. <a id="pagePrecedente"></a>';
		}
		echo menuAdministration().$resultat;
	}
	function articleEdition($id)
	{
		if(jeSuisAdmin() || jeSuisRedacteur() )
		{
			require('fonctionBdd.php');
			$requete = 'SELECT * FROM `articles` WHERE `artId` = '.intval($id);
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$article = array("titre" => $row->artTitre, "date" => $row->artDate,
				"auteur" => $row->artAuteur, "contenu" => $row->artContenu,
				"valide" => $row->artValide, "rubrique" => $row->artRubrique);
				$formulaireNom = 'Modifier un article';
				$inputSubmit = '<input type="hidden" name="articleId" value="'. intval($id) .'" />
				<input type="submit" value="Enregistrer et quitter" onsubmit="editor.post()" />
				<input type="button" id="sauvegarderArticle" value="Enregistrer et rester" onclick="editor.post()" />';
				$rubriqueCourante = $row->artRubrique;
			}
			else
			{
				$article = array("titre" => "Sans Titre", "rubrique" => 0,
								"date" => date("Y-m-d H:i:s"), "valide" => 0,
								"auteur" => $_SESSION['utilisateur']['id'], "contenu" => "");
				$formulaireNom = 'Créer un nouvel article';
				$inputSubmit = '<input type="hidden" name="articleId" value="nouveau" />
				<input type="submit" value="Enregistrer et quitter" onsubmit="editor.post()" />
				<input type="button" id="sauvegarderArticle" value="Enregistrer et rester" onclick="editor.post()"/>';
			}
			$requete = 'SELECT * FROM `rubriques` WHERE `rubRedirection` = 0';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			$listeRubrique = ' <option style="text-align:center;" disabled>RUBRIQUES NORMALES</option>';
			while($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				if(isset($rubriqueCourante) && $row->rubId == $rubriqueCourante)
				{
					$listeRubrique .= '<option selected="selected">Rubrique '. $row->rubId .': '. $row->rubNom .'</option>';
				}
				else
				{
					$listeRubrique .= '<option>Rubrique '. $row->rubId .': '. $row->rubNom .'</option>';
				}
			}
			$requete = 'SELECT * FROM `rubriques` WHERE `rubRedirection` = 1';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			$listeRubrique .= ' <option style="text-align:center;" disabled>RUBRIQUES REDIRIGEES</option>';
			while($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				if(isset($rubriqueCourante) && $row->rubId == $rubriqueCourante)
				{
					$listeRubrique .= '<option selected="selected">Rubrique '. $row->rubId .': '. $row->rubNom .'</option>';
				}
				else
				{
					$listeRubrique .= '<option>Rubrique '. $row->rubId .': '. $row->rubNom .'</option>';
				}
			}
			
			$resultat = menuAdministration().'<fieldset class="articleEdition">
							<legend><h2 class="nomFormulaireEdition">'. $formulaireNom .'</h2></legend>
							<table>
								<tr>
									<td>
										<form class="conteneurEditeur" method="POST" action="?moteur=formulaire&objet=article">
											<table>
												<tr>
													<th colspan="2">Titre</th>
													<th>Placer dans</th>
												</tr>
												<tr>
													<td colspan="2"><input id="titreArticle" type="text" name="articleTitre" value="'. $article['titre'] .'" placeholder="titre" /></td>
													<td><select id="selecteurRubrique" name="articleRubrique" >'. $listeRubrique .'</select></td>
												</tr>
												<tr>
													<th colspan="3">Contenu</th>
												</tr>
												<tr>
													<td colspan="3">
														<textarea id="tinyeditor" class="zoneEditable" name="contenuArticle" style="width: 400px; height: 200px">'. $article['contenu'] .'</textarea>
														<script src="js/tyni.editor.ini.js"></script>
													</td>
												</tr>
											</table>
											<br />
											'. $inputSubmit .'
										</form>
									</td>
									<td style="vertical-align:top;">'. outilsEdition(true, true) .'</td>
								</tr>
							</table>
						</fieldset>
						<script src="js/editionArticle.js"></script>';
		}
		else
		{
			$resultat = 'Vous ne disposez pas des droits suffisants pour acceder à cette partie du site. <a id="pagePrecedente"></a>';
		}
		echo $resultat;
	}
	function outilsEdition($miseEnPage = true, $hebergement = false)
	{
		$resultat = '<table><tr><th>Outils d\'intégration</th></tr>';
		if( $miseEnPage)
		{
			$resultat .= '<tr>
							<td>
								<div class="miseEnPage">
									<h3>Mise en page</h3><br />
									<img id="pdf" src="img/file.png" title="Intégrer un document pdf"/>
									<img id="music" src="img/music.png" title="Intégrer un fichier audio"/>
									<img id="camera" src="img/picture.png" title="Intégrer une image"/>
									<img id="film" src="img/film.png" title="Intégrer une video"/>
									<img id="ruptureUne" src="img/scissors.png" title="Déclarer une rupture de texte pour le format Une"/>
									<img id="ruptureBreve" src="img/scissors.png" title="Déclarer une rupture de texte pour le format Breve"/>
								</div><br />
								<i>
									Les outils ci-dessus ne fonctionne que si le WYSIWYG est désactivé.<br />
									Le code s\'insèrera alors au niveau du pointeur de texte.
								</i>
								<hr />
							</td>
						</tr>';
		}
		if($hebergement)
		{
			scriptEdition('formulaireAjax');
			$resultat .= '<tr>
							<td>
								<div class="hebergement"><h3>Hebergeur de fichier</h3>
									<form id="editeurHebergement" method="POST" action="php/operationUpload.php" enctype="multipart/form-data">
										<input type="file" name="fichier" /><br />
										<input id="fichierEnvoye" type="hidden" name="nomFormulaire" value="hebergementFichier"/>
										<input type="submit" value="Envoyer le fichier" />
									</form>
									<div id="messageHebergement" class="detail"></div>
									<div id="progressionHebergement"></div>
								</div><br />
								<i>
									Cet outil ajoute votre fichier dans la médiathèque du site.<br />
									Le code fournie est à insérer dans l\'éditeur avec le mode WISIWYG désactivé.<br />
									Pour désactiver le mode WISIWYG du lecteur, cliquez sur le bouton "source" en dessous de l\'éditeur de texte.
								</i>
							</td>
						</tr>';
		}
		$resultat .='</table>';
		return $resultat;
	}
	function scriptEdition($nom, $unique = true)
	{
		$url = 'js/'.$nom.'.js';
		if(file_exists($url) && $unique === true)
		{
			if($unique === true)
			{
				echo '<script>';
				include_once($url);
				echo '</script>';
			}
			else
			{
				echo '<script>';
				include($url);
				echo '</script>';
			}
		}
	}
	function personneEdition($id='nouveau')
	{
		if($id == 'nouveau')
		{
			if(jeSuisAdmin())
			{
				$resultat = '<fieldset class="zoneAdministration">
					<legend><h2>Créer un nouvel utilisateur</h2></legend>
					<form id="creerUtilisateur" method="POST" action="?moteur=formulaire&objet=profil">
						<input type="hidden" name="id" value="nouveau"/>
						<table>
							<tr>
								<td  style="vertical-align:top;">
									<fieldset>
										<legend>Identification</legend>
										<table>
											<tr>
												<td>Nom</td>
												<td><input type="text" name="nom" placeholder="nom" /></td>
											<tr>
											<tr><td colspan="2" class="notifNom"></td></tr>
											<tr>
												<td>Prénom</td>
												<td><input type="text" name="prenom" placeholder="prénom" /></td>
											</tr>
											<tr><td colspan="2" class="notifPrenom"></td></tr>
											<tr>
												<td>Email</td>
												<td><input type="text" name="email" placeholder="adresse email" /></td>
											</tr>
											<tr><td colspan="2" class="notifEmail"></td></tr>
											<tr>
												<td>Rôle</td>
												<td>
													<select name="role">
														<option value="2">Rédacteur</option>
														<option value="1">Administrateur</option>
													</select>
												</td>
											</tr>
											<tr><td colspan="2" class="notifRole"></td></tr>
										</table>
										<input type="submit" value="Créer l\'utilisateur" onclick="editor.post()"/>
									</fieldset>
								</td>
								<td style="vertical-align:top;">
									<fieldset>
										<legend>Description</legend>
										<textarea id="tinyeditor" class="zoneEditable" name="description" style="width:40em; max-width:45em; min-height:15em;" onclick="editor.post()"></textarea>
									</fieldset>
								</td>
							</tr>
						</table>
					</form>
				</fieldset>';
			}
			else
			{
				$resultat = 'Vous ne disposez pas de suffisament de droits pour créer de nouveaux utilisateurs.<br />
				<a id="pagePrecedente"></a>';
			}
		}
		else
		{
			if((jeSuisAdmin() && ilEstPasAdmin($id)) || cMonProfil($id))
			{
				require('fonctionBdd.php');
				$requete = 'SELECT * FROM `personnes` WHERE `perId` = '.intval($id);
				$stmt = $bdd->prepare($requete);
				if($stmt->execute())
				{
					if($row = $stmt->fetch(PDO::FETCH_OBJ))
					{
					
						if(cMonProfil($id))
						{
							$aide = 'Vous allez modifer votre profil. Pour cela vous devez remplir tout les champs avec les valeurs souhaitées.<br />
							Retapez le mot de passe actuel dans le champ <b><i>"Nouveau mot de passe"</i></b> pour ne pas changer votre mot de passe.';
						}
						else
						{
							$aide = 'En tant qu\'administrateur vous pouvez modifier votre compte et celui de tout les rédacteurs du site.<br />
							Vous ne pouvez cependant pas modifier le mot de passe d\'un autre utilisateur. Par conséquent, il est inutile de remplir les champs de mots de passe.';
						}
						
						$resultat ='<fieldset class="zoneAdministration">
										<legend><h2>Modifier le profil de '.$row->perNom.' '.$row->perPrenom.'</h2></legend>
										<form method="POST" action="?moteur=formulaire&objet=profil">
											<input type="hidden" name="id" value="'. $row->perId.'" />
											<fieldset>
												<legend>Votre attention s\'il vous plait !</legend>
												<p class="detail">'.$aide.'</p>
											</fieldset>
											<table>
												<tr>
													<tr>
														<td style="vertical-align:top;">
															<fieldset>
																<legend>Identification</legend>
																<table>
																	<tr><td>Nom</td><td><input type="text" name="nom" value="'.$row->perNom.'" /></td></tr>
																	<tr><td>Prénom</td><td><input type="text" name="prenom" value="'.$row->perPrenom.'" /></td></tr>
																	<tr><td>Email</td><td><input type="text" name="email" value="'.$row->perEmail.'" /></td></tr>
																	<tr>
																		<td>Rôle</td>
																		<td>
																			<select name="role">
																				<option value="1" '. (($row->perRole == 1)?'selected="selected"':'').'>Administrateur</option>
																				<option value="2" '. (($row->perRole == 2)?'selected="selected"':'').'>Rédacteur</option>
																			</select>
																		</td>
																	</tr>
																	<tr>
																		<td>Statut du compte</td>
																		<td>
																			<select name="activite">
																				<option value="1">Compte activé</option>
																				<option value="0">Compte bloqué</option>
																			</select>
																		</td>
																	</tr>
																	<tr><td>Mot de passe</td><td><input name="code" type="password" placeholder="tapez votre mot de passe"/></td></tr>
																	<tr><td>Nouveau mot de passe</td><td><input name="nouveauCode" type="password" placeholder="tapez votre mot de passe"/></td></tr>
																</table>
															</fieldset>
															<input type="submit" value="Enregistrer les modifications" />
														</td>
														<td style="vertical-align:top;">
															<fieldset>
																<legend>Description</legend>
																<textarea id="tinyeditor" class="zoneEditable" name="description" style="width:40em; max-width:45em; min-height:15em;" onclick="editor.post()">'.$row->perDescription.'</textarea>
															</fieldset>
														</td>
													</tr>
												<tr>
											</table>
										</form>
									</fieldset>';
					}
					else
					{
						$resultat='<fieldset class="zoneAdministration">
						<legend>Erreur</legend>
							<p>L\'utilisateur dont vous souhaitez modificer le profil n\'existe pas.</p>
						</fieldset>';
					}
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					$resultat = 'Une erreur est survenue. Code erreur SQL: '.$codeErreur[0].' (driver '.$codeErreur[1].')\n'.$codeErreur[2];
				}
			}
			else
			{
				$resultat = 'Vous n\'avez pas le droit de modifier ce profil';
			}
		}
		echo menuAdministration().$resultat.'<script src="js/tyni.editor.ini.js"></script>';
	}
	
	function metaEdition($id='')
	{
		if(jeSuisAdmin())
		{
			$resultat = '
			<form method="POST" action="?moteur=formulaire&objet=metaInfo">
				<textarea name="metaInfo">'.informationSite('meta').'</textarea><br />
				<input type="submit" value="Enregistrer les modifications" />
			</form>';
		}
		else
		{
			$resultat = 'Vous n\'avez pas le droit de modifier les méta-informations du site.
			<a id="pagePrecedente"></a>
			<a href="?moteur=administration&objet=index">Retourner sur l\'index d\'administration</a>
			<a href="?moteur=index&">Site en acces public</a>';
		}
		echo menuAdministration().'<fieldset class="articleEdition">
			<legend><h2>Editer les méta-informations du site web</h2></legend>
			'.$resultat.'
		</fieldset>';
	}
	
	function headerEdition($id='')
	{
		if(jeSuisAdmin())
		{
			$resultat = '
			<form method="POST" action="?moteur=formulaire&objet=header">
				<textarea name="header">'.informationSite('header').'</textarea><br />
				<input type="submit" value="Enregistrer les modifications" />
			</form>';
		}
		else
		{
			$resultat = 'Vous n\'avez pas le droit de modifier l\'entête du site.
			<a id="pagePrecedente"></a>
			<a href="?moteur=administration&objet=index">Retourner sur l\'index d\'administration</a>
			<a href="?moteur=index&">Site en acces public</a>';
		}
		echo menuAdministration().'<fieldset class="articleEdition">
			<legend><h2>Editer l\'entête du site web</h2></legend>
			'.$resultat.'
		</fieldset>';
	}
	
	
	function footerEdition($id='')
	{
		if(jeSuisAdmin())
		{
			$resultat = '
			<form method="POST" action="?moteur=formulaire&objet=footer">
				<textarea name="footer">'.informationSite('footer').'</textarea><br />
				<input type="submit" value="Enregistrer les modifications" />
			</form>';
		}
		else
		{
			$resultat = 'Vous n\'avez pas le droit de modifier le pied de page du site.
			<a id="pagePrecedente"></a>
			<a href="?moteur=administration&objet=index">Retourner sur l\'index d\'administration</a>
			<a href="?moteur=index&">Site en acces public</a>';
		}
		echo menuAdministration().'<fieldset class="articleEdition">
			<legend><h2>Editer l\'entête du site web</h2></legend>
			'.$resultat.'
		</fieldset>';
	}
?>