<?php
	function creerCorbeille()
	{
		if(!is_dir('corbeille'))
		{
			mkdir('corbeille', 0777);
		}
	}

	function preparerCorbeille($cible, $delaiSuplementaire=0)
	{
		/*
			L'url cible doit être relative au fichier index
			car seul le fichier index peut appeler la fonction qui vide la corbeille
		*/
		$delai = time()+intval($delaiSuplementaire);
		$compartimentCorbeille = $delai.'_'.base64_encode($cible).'.txt';
		$url = (is_dir('../corbeille'))? '../corbeille/'.$compartimentCorbeille : 'corbeille/'.$compartimentCorbeille ;
		$fp = fopen($url, 'w+');
		fwrite($fp, $cible);
		fclose($fp);
	}
	
	function viderCorbeille($delai = 120)
	{
		$delai = intval($delai);
		if($_SERVER['PHP_SELF'] == '/index.php')
		{
			$delai = ($delai < 120)?120:$delai;
			$listeFichiers = scandir('corbeille');
			unset($listeFichiers[array_search('.', $listeFichiers)]);
			unset($listeFichiers[array_search('..', $listeFichiers)]);
			unset($listeFichiers[array_search('.htaccess', $listeFichiers)]);
			foreach($listeFichiers as $logCorbeille)
			{
				$dateEffacement = explode('_',$logCorbeille);
				if(($dateEffacement[0]+$delai) < time())
				{
					$cibleEffacement = file_get_contents('corbeille/'.$logCorbeille); //on retrouve le vrai fichier à effacer
					if(file_exists($cibleEffacement)) { unlink($cibleEffacement); } // on efface le fichier ciblé par le fichier corbeille
					unlink('corbeille/'.$logCorbeille); // on efface le log de corbeille
				}
			}
		}
	}

	




?>