<?php
	function obtenirArticle($champ, $valeur, $mode = "complet", $nombre=1)
	{
		require('fonctionBdd.php');
		$_CHAMPS = array("id", "apres_date", "avant_date", "auteur", "titre", "rubrique", "epingle");
		$_MODES = array("complet", "breve", "une", "liste");
		$nombre = max(1, intval($nombre));
		$_SELECT = array("all" => 'SELECT * FROM `articles`');
		$_JOINTURE = array("personnes" => 'JOIN `personnes` ON `perId` = `artAuteur`',
						   "rubrique" => 'JOIN `rubriques` ON `rubId` = `artRubrique`');
		$_RECHERCHER = array("id" => $_SELECT['all'].' '. $_JOINTURE['personnes'] .' '. $_JOINTURE['rubrique'] .' WHERE `artId` = :valeur AND `artValide` = 1 LIMIT '. $nombre .'',
		"apres_date" => $_SELECT['all'].' '. $_JOINTURE['personnes'] .' '. $_JOINTURE['rubrique'] .' WHERE `artDate` >= :valeur AND `artValide` = 1 ORDER BY `artDate` DESC LIMIT '. $nombre .'',
		"avant_date" => $_SELECT['all'].' '. $_JOINTURE['personnes'] .' '. $_JOINTURE['rubrique'] .' WHERE `artDate` <= :valeur AND `artValide` = 1 ORDER BY `artDate` DESC LIMIT '. $nombre .'',
		"auteur" => $_SELECT['all'].' '. $_JOINTURE['personnes'] .' '. $_JOINTURE['rubrique'] .' WHERE `artAuteur` = :valeur AND `artValide` = 1 ORDER BY `artDate` DESC LIMIT '. $nombre .'',
		"titre" => $_SELECT['all'].' '. $_JOINTURE['personnes'] .' '. $_JOINTURE['rubrique'] .' WHERE `artTitre` LIKE :valeur AND `artValide` = 1 ORDER BY `artDate` DESC LIMIT '. $nombre .'',
		"rubrique" => $_SELECT['all'].' '. $_JOINTURE['personnes'] .' '. $_JOINTURE['rubrique'] .' WHERE `artRubrique` = :valeur AND `artValide` = 1 ORDER BY `artDate` DESC LIMIT '. $nombre .'',
		"epingle" => $_SELECT['all'].' '. $_JOINTURE['personnes'] .' '. $_JOINTURE['rubrique'] .' WHERE `artEpingle` = :valeur AND `artValide` = 1 ORDER BY `artDate` DESC LIMIT '. $nombre .'');
		$champ = (in_array($champ, $_CHAMPS))? $champ : $_CHAMPS[0];
		$mode = (in_array($mode, $_MODES))? $mode : $_MODES[0];
		switch($champ)
		{
			case 'apres_date':
			$stmt = $bdd->prepare($_RECHERCHER['apres_date']);
			$stmt->bindParam(':valeur', $valeur, PDO::PARAM_STR);
			break;
			case 'avant_date':
			$stmt = $bdd->prepare($_RECHERCHER['avant_date']);
			$stmt->bindParam(':valeur', $valeur, PDO::PARAM_STR);
			break;
			case 'auteur':
			$stmt = $bdd->prepare($_RECHERCHER['auteur']);
			$stmt->bindParam(':valeur', $valeur, PDO::PARAM_STR);
			break;
			case 'titre':
			$stmt = $bdd->prepare($_RECHERCHER['titre']);
			$stmt->bindParam(':valeur', $valeur, PDO::PARAM_STR);
			break;
			case 'rubrique':
			$stmt = $bdd->prepare($_RECHERCHER['rubrique']);
			$stmt->bindParam(':valeur', $valeur, PDO::PARAM_INT);
			break;
			case 'epingle':
			$stmt = $bdd->prepare($_RECHERCHER['epingle']);
			$stmt->bindParam(':valeur', $valeur, PDO::PARAM_INT);
			break;
			default:
			$stmt = $bdd->prepare($_RECHERCHER['id']);
			$stmt->bindParam(':valeur', $valeur, PDO::PARAM_INT);
			break;
		}
		$stmt->execute();
		$resultat = '';
		while($art = $stmt->fetch(PDO::FETCH_OBJ))
		{
			switch($mode)
			{
				case 'une':
					$contenuResume = resumeArticle($art->artContenu, 'une');
					$motsCles = array(':titre', ':contenu', ':articleId');
					$valeursCorrespondantes = array($art->artTitre, $contenuResume, $art->artId);
					$resultat .= str_replace($motsCles,$valeursCorrespondantes,architectureArticle($mode));
				break;
				case 'breve':
					$contenuResume = resumeArticle($art->artContenu, 'breve');
					$motsCles = array(':titre', ':contenu', ':articleId');
					$valeursCorrespondantes = array($art->artTitre, $contenuResume, $art->artId);
					$resultat .= str_replace($motsCles,$valeursCorrespondantes,architectureArticle($mode));
				break;
				case 'complet':
					$motsCles = array(':titre', ':date', ':auteurId', ':auteurPrenom', ':auteurNom', ':rubriqueId', ':rubriqueNom', ':contenu');
					$valeursCorrespondantes = array($art->artTitre, $art->artDate, $art->perId, $art->perPrenom, $art->perNom, $art->rubId, $art->rubNom, $art->artContenu);
					$resultat .= str_replace($motsCles,$valeursCorrespondantes,architectureArticle());
				break;
				case 'liste':
					$motsCles = array(':titre', ':date', ':auteurId', ':auteurPrenom', ':auteurNom', ':rubriqueId', ':rubriqueNom', ':contenu', ':articleId');
					$valeursCorrespondantes = array($art->artTitre, $art->artDate, $art->perId, $art->perPrenom, $art->perNom, $art->rubId, $art->rubNom, $art->artContenu, $art->artId);
					$resultat .= str_replace($motsCles,$valeursCorrespondantes,architectureArticle($mode));
				break;
			}
		}
		return $resultat;
	}
	function resumeArticle($contenu, $mode = 'une', $rupturePersonalisee ='')
	{
		switch ($mode)
		{
			case 'une': $rupture = '<!-- FIN UNE -->'; break;
			case 'breve': $rupture = '<!-- FIN BREVE -->'; break;
			default: $rupture = $rupturePersonalisee; break;
		}
		$resume =  strstr($contenu, $rupture, true);
		$resultat = ($resume === false)?$contenu:$resume;
		return $resultat;
	}
	function architectureArticle($type = 'complet')
	{
		$complet = '<section class="article"><h2>:titre</h2><div class="clear"></div><div class="metaInformations">Publié le :date par <a href="profil-visualiser;:auteurId.html">:auteurPrenom :auteurNom</a> dans la rubrique <a href="rubrique-:rubriqueId.html">:rubriqueNom</a></div><div class="contenu">:contenu</div></section>';
		$breve = '<section class="breve"><h2><a href="article-:articleId.html">:titre</a></h2><section>:contenu... <a class="lireSuite" href="article-:articleId.html">Lire la suite</a></section></section>';
		$une = '<section class="une"><h2><a href="article&-:articleId.html">:titre</a></h2><div class="clear"></div><section class="contenu">:contenu... <a class="lireSuite" href="article-:articleId.html">Lire la suite</a></section></section>';
		$liste = '<section class="liste"><h2><a href="article-:articleId.html">:titre</a></h2><div class="metaInformations">Publié le :date par <a href="profil-visualier;:auteurId.html">:auteurPrenom :auteurNom</a> dans la rubrique <a href="rubrique-:rubriqueId.html">:rubriqueNom</a></div><a class="lireSuite" href="article-:articleId.html">Lire cet article</a></section>';
		$brouillon = '<tr><td>:element</td><td>:articleId</td><td>:titre</td><td>:nom :prenom</td><td><a href="rubrique-:rubriqueId.html">:rubriqueNom</a></td><td>:date</td><td><a href="editer-article;:articleId.html"><img src="img/pencil.png" alt="éditer" title="Editer l\'article" /></a></td><td><img class="approuverArticle" data-id=:articleId data-pagination=":pageCourante" src="img/thumbs_up.png" alt="approuver" tile="Approuver l\'article" /></td><td><img class="supprimerArticle" data-id=":articleId" src="img/remove_2.png" alt="Supprimer" title="Supprimer l\'article"/></td></tr>';
		$publique = '<tr><td>:element</td><td>:articleId</td><td>:titre</td><td>:nom :prenom</td><td><a href="rubrique-:rubriqueId.html">:rubriqueNom</a></td><td>:date</td><td><a href="editer-article;:articleId.html"><img src="img/pencil.png" alt="éditer" title="Editer l\'article" /></a></td><td><img class="desapprouverArticle" data-id=:articleId data-pagination=":pageCourante" src="img/thumbs_down.png" alt="desapprouver" tile="Désapprouver l\'article" /></td></tr>';
		$recherche = '<fieldset class="rechercher"><legend><h3>Rechercher un article</h3></legend><table><tr><th>Titre</th><td><input class="chercherTitre" type="text" placeholder="titre"/></td><td rowspan="3" style="vertical-align:top;"><table class="resultatRecherche"></table></td><tr><th>Contenu</th><td><textarea class="chercherContenu"></textarea></td></tr><tr><th>Date</th><td>Posté <select class="operateurDate"><option>avant</option><option>après</option><option>exactement</option></select><br />le <input class="chercherDate" type="text" placeholder="'. date('Y-m-d', time()) .'" /></td></tr></table></fieldset>';
		$architecture = array('complet' => $complet, 'breve' => $breve, 'une' => $une, 'liste' => $liste, 'brouillon' => $brouillon, 'publique' => $publique, 'recherche'=>$recherche);
		$type = (array_key_exists($type, $architecture))? $type : 'complet';
		return $architecture[$type];
	}
	function brouillonArticle($page = 0, $limite = 10)
	{
		$paginationPrecedent = $page - 1; $paginationSuivant = $page + 1; $page *= $limite; $i = $page;
		require('fonctionBdd.php');
		$requete = 'SELECT * FROM `articles`
		JOIN `personnes` ON `perId` = `artAuteur`
		JOIN `rubriques` ON `rubId` = `artRubrique`
		WHERE `artValide` = 0
		ORDER BY `artDate` DESC, `artId` ASC
		LIMIT :page, :limite';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':page', $page, PDO::PARAM_INT);
		$stmt->bindParam(':limite', $limite, PDO::PARAM_INT);
		$stmt->execute();
		$resultat ='<table><tr><th>#</th><th>id</th><th>Titre</th><th>Auteur</th><th>Rubrique associée</th><th>Date de création</th><th>Editer</th><th>Approuver</th><th>Supprimer</th></tr>';
		while($art = $stmt->fetch(PDO::FETCH_OBJ))
		{
			$i++;
			$esquisse  = array(':element',':articleId',':titre',':nom',':prenom',':rubriqueId',':rubriqueNom',':date', ':pageCourante');
			$dessin = array($i,$art->artId,$art->artTitre,$art->perNom,$art->perPrenom,$art->rubId, $art->rubNom,$art->artDate, ($paginationPrecedent+1));
			$resultat .= str_replace($esquisse , $dessin,  architectureArticle('brouillon'));
		}
		$resultat .= '</table>';
		$nombreLignes = 0;
		$requete = 'SELECT COUNT(*) as `nombreLignes` FROM `articles`
		JOIN `personnes` ON `perId` = `artAuteur`
		JOIN `rubriques` ON `rubId` = `artRubrique`
		WHERE `artValide` = 0';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':page', $page, PDO::PARAM_INT);
		$stmt->bindParam(':limite', $limite, PDO::PARAM_INT);
		$stmt->execute();
		if($art = $stmt->fetch(PDO::FETCH_OBJ)) { $nombrePage = 1+round(($art->nombreLignes/$limite),1); }
		$propositionsPage ='<option>Selectionnez...</option>';
		for($i=0; $i<$nombrePage; $i++)
		{
			$propositionsPage .= '<option>'. $i .'</option>';
		}
		$resultat .= '<a class="paginationPrecedent" data-pagination="'. $paginationPrecedent .'">Page précédente</a> <a class="paginationSuivant" data-pagination="'. $paginationSuivant .'">Page suivante</a> || Aller à la page: <select class="paginationSautPage">'. $propositionsPage .'</select>';
		return $resultat;
	}
	function  publiqueArticle($page = 0, $limite = 10)
	{
		$paginationPrecedent = $page - 1; $paginationSuivant = $page + 1; $page *= $limite; $i = $page;
		require('fonctionBdd.php');
		$requete = 'SELECT * FROM `articles`
		JOIN `personnes` ON `perId` = `artAuteur`
		JOIN `rubriques` ON `rubId` = `artRubrique`
		WHERE `artValide` = 1
		ORDER BY `artDate` DESC, `artId` ASC
		LIMIT :page, :limite';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':page', $page, PDO::PARAM_INT);
		$stmt->bindParam(':limite', $limite, PDO::PARAM_INT);
		$stmt->execute();
		$resultat ='<table><tr><th>#</th><th>id</th><th>Titre</th><th>Auteur</th><th>Rubrique associée</th><th>Date de création</th><th>Editer</th><th>Désapprouver</th></tr>';
		while($art = $stmt->fetch(PDO::FETCH_OBJ))
		{
			$i++;
			$esquisse  = array(':element',':articleId',':titre',':nom',':prenom',':rubriqueId',':rubriqueNom',':date', ':pageCourante');
			$dessin = array($i,$art->artId,$art->artTitre,$art->perNom,$art->perPrenom,$art->rubId,$art->rubNom,$art->artDate, ($paginationPrecedent+1));
			$resultat .= str_replace($esquisse , $dessin,  architectureArticle('publique'));
		}
		$resultat .= '</table>';
		$nombreLignes = 0;
		$requete = 'SELECT COUNT(*) as `nombreLignes` FROM `articles`
		JOIN `personnes` ON `perId` = `artAuteur`
		JOIN `rubriques` ON `rubId` = `artRubrique`
		WHERE `artValide` = 1';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':page', $page, PDO::PARAM_INT);
		$stmt->bindParam(':limite', $limite, PDO::PARAM_INT);
		$stmt->execute();
		if($art = $stmt->fetch(PDO::FETCH_OBJ)) { $nombrePage = 1+round(($art->nombreLignes/$limite),1); }
		$propositionsPage ='<option>Selectionnez...</option>';
		for($i=0; $i<$nombrePage; $i++)
		{
			$propositionsPage .= '<option>'. $i .'</option>';
		}
		$resultat .= '<a class="paginationPrecedent" data-pagination="'. $paginationPrecedent .'">Page précédente</a> <a class="paginationSuivant" data-pagination="'. $paginationSuivant .'">Page suivante</a> || Aller à la page: <select class="paginationSautPage">'. $propositionsPage .'</select>';
		return $resultat;
	}
	function approuverArticle($id)
	{
		if(jeSuisAdmin())
		{
			require('fonctionBdd.php');
			$requete = 'UPDATE `articles` SET `artValide` = 1 WHERE `artId` = :id AND `artValide` = 0';
			$stmt = $bdd->prepare($requete);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
			if($stmt->execute())
			{
				$nbrOperation = $stmt->rowCount();
				$operation = ($nbrOperation > 1)? $nbrOperation.' opérations effectuées: ' : 'Une opération effectuée: ';
				$resultat = $operation.' l\'article '. $id .' a été publié avec succes.';
			}
			else
			{
				$codeErreur = $stmt->errorInfo();
				$resultat = '<br /><fieldset>
					<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
					<p>'. $codeErreur[2] .'</p>
				</fieldset>';
			}
			return $resultat;
		}
		else
		{
			$resultat = 'Vous ne disposez pas des droits suffisants pour approuver un article.';
		}
	}
	function desapprouverArticle($id)
	{
		if(jeSuisAdmin())
		{
			require('fonctionBdd.php');
			$requete = 'UPDATE `articles` SET `artValide` = 0 WHERE `artId` = :id AND `artValide` = 1';
			$stmt = $bdd->prepare($requete);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			if($stmt->execute())
			{
				$nbrOperation = $stmt->rowCount();
				$operation = ($nbrOperation > 1)? $nbrOperation.' opérations effectuées: ' : 'Une opération effectuée: ';
				$resultat = $operation.' l\'article '. $id .' a été désaprouvé avec succes.';
			}
			else
			{
				$codeErreur = $stmt->errorInfo();
				$resultat = '<br /><fieldset>
					<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
					<p>'. $codeErreur[2] .'</p>
				</fieldset>';
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas des droits suffisants pour desapprouver un article.';
		}
		return $resultat;
	}
	function supprimerArticle($id)
	{
		if(jeSuisAdmin())
		{
			if($id < 2)
			{
				$resultat = 'Erreur: l\'article que vous tentez de supprimer est necessaire au bon fonctionnement du site web.';
			}
			else
			{
				require('fonctionBdd.php');
				$requete = 'DELETE FROM `articles` WHERE `artId` = :id AND `artValide` = 0';
				$stmt = $bdd->prepare($requete);
				$stmt->bindParam(':id', $id, PDO::PARAM_INT);
				if($stmt->execute())
				{
					$nbrOperation = $stmt->rowCount();
					if($nbrOperation == 1)
					{
						$resultat = 'L\'article '. $id .' a été supprimer avec succes.';
					}
					elseif($nbrOperation < 1)
					{
						$resultat = 'L\'article '. $id .' n\'a pas été supprimé. Seuls les articles en attente validation peuvent etre supprimés.';
					}
					else
					{
						$resultat = 'Un problème est peut être survenu. '.$nbrOperation.' articles ont été supprimés au lieu d\'un comme prévu lors d\'un fonctionnement normal.';
					}
				}
				else
				{
					$codeErreur = $stmt->errorInfo();
					$resultat = '<br /><fieldset>
						<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
						<p>'. $codeErreur[2] .'</p>
					</fieldset>';
				}
			}
		}
		else
		{
			$resultat = 'Vous ne disposez pas des droits suffisants pour desapprouver un article.';
		}
		return $resultat;
	}
	function rechercherArticle($titre, $contenu, $filtreDate, $date)
	{
		switch($filtreDate)
		{
			case 'avant':
			$operateurDate = '<';
			break;
			case 'exactement':
			$operateurDate = '=';
			break;
			default:
			$operateurDate = '>';
			break;
		}
		$titre = str_replace(' ','%',$titre);
		$contenu = str_replace(' ','%',$contenu);
		$date = (strlen($date)<3)? date('Y-m-d',time()) : $date;
		require('fonctionBdd.php');
		$requete = 'SELECT * FROM `articles`
		JOIN `personnes` ON `artAuteur` = `perId`
		JOIN `rubriques` ON `artRubrique` = `rubId`
		WHERE `artTitre` LIKE \'%'.$titre.'%\'
		AND `artContenu` LIKE \'%'. $contenu.'%\'
		AND `artDate` '.$operateurDate.' :date';
		$requeteE = 'SELECT * FROM `articles`
		JOIN `personnes` ON `artAuteur` = `perId`
		JOIN `rubriques` ON `artRubrique` = `rubId`
		WHERE `artTitre` LIKE \'%'.$titre.'%\'
		AND `artContenu` LIKE \'%'. $contenu.'%\'
		AND `artDate` '.$operateurDate.' '.$date.'';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':date', $date, PDO::PARAM_INT);
		$stmt->execute();
		$resultat = '';
		while($art = $stmt->fetch(PDO::FETCH_OBJ))
		{
			$resultat .= '<tr><td>'. $art->artTitre .'</td>
				<td>'.$art->perNom .' '. $art->perPrenom .'</td>
				<td>'.$art->rubNom .'</td><td>'.$art->artDate .'</td>
				<td>'.(($art->artValide)?'oui':'non').'</td></tr>';
		}
		$aucunResultat = '<td colspan="5">Aucun article ne correspond à votre recherche</td>';
		$resultat = ($resultat == '')? $aucunResultat: $resultat;
		return $resultat;
	}
	
	function desepinglerArticle()
	{
		require('fonctionBdd.php');
		$requete = 'UPDATE `articles` SET `artEpingle` = 0 WHERE `artEpingle` != 0';
		$stmt = $bdd->prepare($requete);
		if($stmt->execute())
		{
			$resultat = true;
		}
		else
		{
			$codeErreur = $stmt->errorInfo();
			$resultat = '<br /><fieldset>
				<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
				<p>'. $codeErreur[2] .'</p>
			</fieldset>';
		}
		return $resultat;
	}
	
	function epinglerArticle($id)
	{
		$id = intval($id);
		require('fonctionBdd.php');
		$requete = 'UPDATE `articles` SET `artEpingle` = 0 WHERE `artEpingle` != 0;
					UPDATE `articles` SET `artEpingle` = 1 WHERE `artId` = :id';
		$stmt = $bdd->prepare($requete);
		$stmt->bindParam(':id', $id, PDO::PARAM_INT);
		if($stmt->execute())
		{
			$resultat = true;
		}
		else
		{
			$codeErreur = $stmt->errorInfo();
			$resultat = '<br /><fieldset>
				<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
				<p>'. $codeErreur[2] .'</p>
			</fieldset>';
		}
		return $resultat;
	}
	function creerArticle($titre, $rubrique, $contenu, $id = 'nouveau')
	{
		if(jeFaisPartieDuStaff())
		{
			require('fonctionBdd.php');
			$_POST['articleId'] = ($id == 'nouveau')?$id: intval($id);
			$_POST['articleTitre'] = $titre;
			$_POST['articleRubrique'] = $rubrique;
			$_POST['contenuArticle'] = $contenu;
			$resultat = array('resultat' =>articleFormulaire(),'id' => $_POST['articleId']);
		}
		else
		{
			$resultat = array('resultat' => 'Vous ne disposez pas de droits suffisants piur créer des articles','id' => $id);
		}
		return $resultat;
	}
?>