<?php
	function indexAdministration($id='index')
	{
		if(jeSuisAdmin() || jeSuisRedacteur())
		{
			$resultat = '<fieldset class="zoneAdministration">
				<legend><h2>Bienvenue sur la page d\'administration</h2></legend>
				<p>'.accueillirStaff().'</p>
				<p>'.quePuisJeFaire().'</p>
			</fieldset>';
		}
		else
		{
			$resultat = 'Vous ne disposez pas de droits suffisants pour acceder à cette  partie du site.<a id="pagePrecedente"></a>
			<a href="index.php">Retourner sur la page d\'accueil</a>';
		}
		echo menuAdministration().$resultat;
	}
	function articleAdministration($id = 'tous')
	{
		if(jeSuisAdmin() || jeSuisRedacteur())
		{
			$attenteValidation = '<fieldset><legend><h4>Articles en attente de validation</h4></legend><div class="attenteValidation">'. brouillonArticle(0) .'</div></fieldset>';
			$articlesValides = '<fieldset><legend><h4>Articles publiés</h4></legend><div class="dejaValide">'. publiqueArticle(0) .'</div></fieldset>';
			$resultat = $attenteValidation.$articlesValides.architectureArticle('recherche');	
		}
		else
		{
			$resultat = 'Vous ne disposez pas des droits suffisants pour acceder à cette partie du site. <a id="pagePrecedente"></a>';
		}
		echo menuAdministration().'
			<fieldset class="zoneAdministration">
				<legend><h2>Gérer les articles</h2></legend>
				'.$resultat.'
			</fieldset>';
	}
	function rubriqueAdministration($id='tous')
	{
		if(jeSuisAdmin() || jeSuisRedacteur())
		{
			require('fonctionBdd.php');
			$requete = 'SELECT * FROM `articles` ORDER BY `artTitre`';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			$listeArticle = '';
			while($art = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$listeArticle .= '<option value="'. $art->artId .'">'. $art->artTitre .'</option>';
			}
			$requete = 'SELECT * FROM `rubriques` ORDER BY `rubNom`';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			$listeRubriques = '';
			while($rub = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$listeRubriques .= '<option value="'. $rub->rubId .'">'. $rub->rubNom .'</option>';
			}
			$requete = 'SELECT * , COUNT( `rubId` ) AS `nbrArticle`
						FROM `rubriques`
						JOIN `articles` ON `artRubrique` = `rubId`
						WHERE `rubRedirection` =1
						GROUP BY `rubId`
						ORDER BY `rubId`';
			$rubriquesRedirigees = '';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			while($rub = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$optionsSelect = str_replace('value="'.$rub->artId.'"', 'value="'.$rub->artId.'" selected="selected"',$listeArticle);
				$rubriquesRedirigees .= '<tr>
					<td>'. $rub->rubId .'</td>
					<td>'. $rub->rubNom .'</td>
					<td><a href="?moteur=editer&objet=rubrique;'.$rub->rubId.'"><img src="img/pencil.png" alt="éditer" title="Editer la rubrique" /></a></td>
					<td><select class="changerRedirection" data-id="'.$rub->rubId.'">'. $optionsSelect .'</select></td>
					<td><img class="annulerRedirection" data-id="'.$rub->rubId.'" src="img/git_delete.png" alt="anuler la redirection" title="Annuler la redirection" /></td>
					<td>
						<select class="cibleDeplacement" data-id="'.$rub->rubId.'">'.$listeRubriques.'</select>
						<input type="button" class="deplacerSupprimer" value="Valider"/>
					</td>
					<td>'.$rub->nbrArticle.'</td>
				</tr>';
			}
			$requete = 'SELECT *, COUNT(`rubId`)as `nbrArticle`
			FROM `rubriques`
			JOIN `articles` ON `artRubrique` = `rubId`
			WHERE `rubRedirection` = 0
            GROUP BY `rubId`
			ORDER BY `rubId`';
			$rubriquesSimples = '';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			while($rub = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$rubriquesSimples .= '<tr>
					<td>'. $rub->rubId .'</td>
					<td>'. $rub->rubNom .'</td>
					<td><a href="?moteur=editer&objet=rubrique;'.$rub->rubId.'"><img src="img/pencil.png" alt="éditer" title="Editer la rubrique" /></a></td>
					<td><select class="changerRedirection" data-id="'.$rub->rubId.'">'. str_replace('value="'.$rub->rubArticle.'"', 'value="'.$rub->rubArticle.'" selected="selected"',$listeArticle) .'</select></td>
					<td><img class="activerRedirection" data-id="'.$rub->rubId.'" src="img/git_pull_request.png" alt="anuler la redirection" title="Annuler la redirection" /></td>
					<td>
						<select class="cibleDeplacement" data-id="'.$rub->rubId.'">'.$listeRubriques.'</select>
						<input type="button" class="deplacerSupprimer" value="Valider"/>
					</td>
					<td>'.$rub->nbrArticle.'</td>
				</tr>';
			}
			$requete = 'SELECT *
			FROM `rubriques`
			WHERE `rubId` NOT IN (SELECT `artRubrique` FROM `articles`)
			GROUP BY `rubId`
			ORDER BY `rubId`';
			$rubriquesVides = '';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			while($rub = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$rubriquesVides .= '<tr>
					<td>'. $rub->rubId .'</td>
					<td>'. $rub->rubNom .'</td>
					<td><a href="?moteur=editer&objet=rubrique;'.$rub->rubId.'"><img src="img/pencil.png" alt="éditer" title="Editer la rubrique" /></a></td>
					<td>
						<select class="cibleDeplacement" data-id="'.$rub->rubId.'">'.$listeRubriques.'</select>
						<input type="button" class="deplacerSupprimer" value="Supprimer"/>
					</td>
				</tr>';
			}
			$resultat ='<fieldset>
							<legend><h4>Rubriques non vides redirigant sur un article</h4></legend>
							<table>
								<tr><th>Id</th><th>Nom de la rubrique</th><th>Editer</th><th>Article associé</th><th>Délier</th><th>Supprimer et déplacer vers...</th><th>Nombre d\'article</th></tr>
								'.$rubriquesRedirigees.'
							</table>
						</fieldset>
						<fieldset>
							<legend><h4>Rubriques non vides sans redirection</h4></legend>
							<table>
								<tr><th>Id</th><th>Nom de la rubrique</th><th>Editer</th><th>Article associé</th><th>Lier</th><th>Supprimer et déplacer vers...</th><th>Nombre d\'article</th></tr>
								'.$rubriquesSimples.'
							</table>
						</fieldset>
						<fieldset>
							<legend><h4>Rubriques vides</h4></legend>
							<p>
								Trouvez ici toutes vos rubriques vides. Ces rubriques ne contiennent aucun article et ne sont pas affichées sur le site en accès public.
							</p>
							<table>
								<tr><th>Id</th><th>Nom de la rubrique</th><th>Editer</th><th>Déplacer vers ... puis supprimer</th></tr>
								'.$rubriquesVides.'
							</table>
						</fieldset>';
			$resultat .= '<script src="js/rubriqueAjax.js"></script>';
		}
		else
		{
			$resultat = 'Vous ne disposez pas des droits suffisants pour acceder à cette partie du site. <a id="pagePrecedente"></a>';
		}
		echo  menuAdministration().'<fieldset class="zoneAdministration">
				<legend><h2>Gérer des rubriques</h2></legend>
				'.$resultat.'
			</fieldset>';
	}
	
	
	function diffusionLettreAdministration($id="")
	{
		$_POST['titre'] = empty($_POST['titre'])?'':$_POST['titre'];
		$_POST['message'] = empty($_POST['message'])?'':$_POST['message'];
		$resultat = '<fieldset class="zoneAdministration">
						<legend><h2>Lettre de diffusion</h2></legend>
						<fieldset>
							<legend><h4>Composition de l\'email</h4></legend>
							<ul class="detail">
								<li>Le titre de email doit contenir au moins 10 caractères (hors caractères spéciaux qui seront supprimés).</li>
								<li>Votre email doit contenir au moins 100 caractères (les caractères spéciaux ne seront pas supprimés).</li>
								<li>L\'email sera envoyé à tous les abonnés du site (<a href="?moteur=administration&objet=abonnement" target="blank">gérer les abonnés</a>).</li>
							</ul>
							<form method="post" action="?moteur=formulaire&objet=diffusionLettre">
								<table>
									<tr>
										<th>Titre</th>
										<td><input type="text" name="titre" value="'.$_POST['titre'].'" placeholder="Titre de votre email" /></td>
									</tr>
									<tr>
										<th>Message</th>
										<td><textarea id="saisieLettreDiffusion" style="width:50em; max-width:800px; height:20em;" name="message" placeholder="votre message">'.$_POST['message'].'</textarea></td>
									</tr>
									<tr>
										<td colspan="2">
											<input type="submit" value="Envoyer cette lettre aux abonnés du site"/>
										</td>
									</tr>
								</table>
							</form>
						</fieldset>
						<fieldset>
							<legend><h4>Apercu de votre email</h4></legend>
							<div id="apercuLettreDiffusion"></div>
						</fieldset>
						<fieldset>
							<legend><h4>Compte email du site</h4></legend>
							<p class="detail">
								<form id="emailSite" action="?moteur=formulaire&objet=emailSite">
									<h4>Compte actuellement utilisé:</h4>
									'.emailSite('consulter').'
									<br />
									<h4>Modifier le compte</h4>
									<input name="email" value="" placeholder="admin@'.$_SERVER['SERVER_NAME'].'"/>
									<input type="submit" />
								</form>
							</p>
						</fieldset>
					</fieldset>
					
					<script src="js/apercuLettreDiffusion.js"></script>
					<script src="js/emailSite.js"></script>';
		echo menuAdministration().$resultat;
	}
	
	function abonnementAdministration($order='Date')
	{
		require('fonctionBdd.php');
		$order = (strtolower($order) == 'date')?'ORDER BY `aboDate`': 'ORDER BY `aboMail`';
		$requete = 'SELECT * FROM `abonnements` '.$order;
		$stmt= $bdd->prepare($requete);
		$stmt->execute();
		$listeAbonnement = '';
		while($row = $stmt->fetch(PDO::FETCH_OBJ))
		{
			$listeAbonnement .= '<tr><td>'. $row->aboId .'</td><td>'. $row->aboMail .'</td><td>'. $row->aboDate .'</td><td><img class="supprimerAbonnement" src="img/remove_2.png" data-id="'.$row->aboId.'" /></td></tr>';
		}
		$resultat = '<fieldset class="zoneAdministration">
					<legend><h2>Gestion des abonnements</h2></legend>
					<fieldset>
						<legend><h4>Ajouter des abonnements</h4></legend>
						<form method="POST" action="?moteur=formulaire&objet=newsletter">
							<table>
								<tr>
									<td rowspan="2">
										<input type="hidden" name="action" value="abonnementMultiple"/>
										<textarea name="mail" placeholder="Adresse email ici"></textarea>
									</td>
									<td><input type="text" name="separation" placeholder="caractere de separation" /></td>
								</tr>
								<tr><td><input type="submit" value="Ajouter cette liste d\'adresse" /></td></tr>
							</table>
						</form>
					</fieldset>
					<fieldset>
						<legend><h4>Liste des abonnés à la lettre de diffusion</h4></legend>
						<table>
							<tr>
								<th>Identifiant</th>
								<th>Adresse</th>
								<th>Date d\'inscription</th>
								<th>Désinscrire</th>
							</tr>
							'.$listeAbonnement.'
						</table>
					</fieldset>
				</fieldset>';
		echo menuAdministration().$resultat.'<script src="js/abonnementAjax.js"></script>';
	}
	
	function menuAdministration()
	{
		$accesAutorise = '<h1>Administration</h1>
		<table>
			<tr>
				<td colspan="4">
					<ul class="menuAdministration">
						<li class="afficheurMenuAdministration"><a>Deployer le menu</a></li>
					</ul>
				</td>
			</tr>
			<tr class="pliageMenuAdministration">
				<td>
					<ul class="menuAdministration">
						<li><a href="administration-index.html">Accueil</a></li><br />
						<li><a href="index.html">Site en acces public</a></li><br />
						<li><a href="administration-apropos.html">A propos</a></li><br />
						<li><a href="http://calypso.murelh.info" target="_blank">Documentation</a></li><br />
						<li><a href="formulaire-deconnexion.html">Deconnexion</a></li><br />
					</ul>
				</td>
				<td>
					<ul class="menuAdministration">
						<li><a href="editer-meta.html">Métas-informations</a></li><br />
						<li><a href="editer-header.html">Entête</a></li><br />
						<li><a href="editer-footer.html">Pied de page</a></li><br />
						<li><a href="administration-theme.html">Thème</a></li><br />
						<li><a href="administration-architecture.html">Architecture</a></li><br />
					</ul>
				</td>
				<td>
					<ul class="menuAdministration">
						<li><a href="administration-utilisateur.html">Gérer les utilisateurs</a></li><br />
						<li><a href="editer-personne;nouveau.html">Créer utilisateur</a></li><br />
						<li><a href="administration-diffusionLettre.html">Lettre de diffusion</a></li><br />
						<li><a href="administration-abonnement.html">Abonnements</a></li><br />
						<li><a href="administration-mediatheque.html">Médiathèque</a></li>
					</ul>
				</td>
				<td>
					<ul class="menuAdministration">
						<li><a href="editer-article;nouveau.html">Créer un article</a></li><br />
						<li><a href="administration-article.html">Gérer les articles</a></li><br />
						<li><a href="administration-rubrique;nouveau.html">Gérer les rubriques</a></li><br />
						<li><a href="editer-rubrique;nouveau.html">Créer une rubrique</a></li><br />
						<li><a href="administration-diaporama.html">Diaporama</a></li><br />
					</ul>
				</td>
			</tr>
			<tr  class="pliageMenuAdministration">
				<td colspan="2">
					<ul class="menuAdministration margin0">
						<li><a href="fonctions-creation.html">Ajouter une fonction</a></li>
					</ul>
				</td>
				<td colspan="2">
					<ul class="menuAdministration margin0">
						<li><a href="fonctions-liste.html">Fonctionnalités</a></li>
					</ul>
				</td>
			</tr>
		</table>
		<script src="js/menuAdministration.js"></script>';
		
		$accesRefuse = '<ul class="menuAdministration">
							<li><a href="index.html">Site en acces public</a></li>
							<li><a href="article-1.html">Se connecter</a></li>
						</ul>';
						
		$resultat = (jeFaisPartieDuStaff())?$accesAutorise:$accesRefuse;
		
		return $resultat;
	}
	function utilisateurAdministration($id="tous")
	{
		$resultat = $listeRedacteur = $listeAdmin ='';
		require('fonctionBdd.php');
		$requete = 'SELECT * FROM `personnes` WHERE `perRole` = 2 ORDER BY `perNom`, `perPrenom`';
		$stmt = $bdd->prepare($requete);
		if($stmt->execute())
		{
			while($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$listeRedacteur .= '<tr>
										<td>'. $row->perNom .'</td>
										<td>'. $row->perPrenom .'</td>
										<td>'. $row->perEmail .'</td>
										<td><a href="?moteur=editer&objet=personne;'.$row->perId.'"><img src="img/pencil.png" alt="modifier" title="Modifier le compte de '. $row->perPrenom .'"/></a></td>
									</tr>';
			}
		}
		else
		{
			$codeErreur = $stmt->errorInfo();
			$resultat .= '<br /><fieldset>
				<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
				<p>'. $codeErreur[2] .'</p>
			</fieldset>';
		}
		$requete = 'SELECT * FROM `personnes` WHERE `perRole` = 1 ORDER BY `perNom`, `perPrenom`';
		$stmt = $bdd->prepare($requete);
		if($stmt->execute())
		{
			while($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$listeAdmin .= '<tr>
					<td>'. $row->perNom .'</td>
					<td>'. $row->perPrenom .'</td>
					<td>'. $row->perEmail .'</td>
					<td><a href="?moteur=editer&objet=personne;'.$row->perId.'"><img src="img/pencil.png" alt="modifier" title="Modifier le compte de '. $row->perPrenom .'"/></a></td>
				</tr>';
			}
		}
		else
		{
			$codeErreur = $stmt->errorInfo();
			$resultat .= '<br /><fieldset>
				<legend>Code erreur SQL: '. $codeErreur[0] .' (driver '. $codeErreur[1] .')</legend>
				<p>'. $codeErreur[2] .'</p>
			</fieldset>';
		}
		
		$resultat .= '<fieldset class="zoneAdministration">
						<legend><h2>Gestion des utilisateurs</h2></legend>
						<fieldset>
							<legend><h4>Liste des rédacteurs</h4></legend>
							<table>
								<tr><th>Nom</th><th>Prénom</th><th>Email</th><th>Modifier</th></tr>
								'.$listeRedacteur.'
							</table>
						</fieldset>
						<fieldset>
							<legend><h4>Liste des administrateurs</h4></legend>
							<table>
								<tr><th>Nom</th><th>Prénom</th><th>Email</th><th>Action disponible</th></tr>
								'.$listeAdmin.'
							</table>
						</fieldset>
					</fieldset>';
		echo  menuAdministration().$resultat;
	}
	
	function diaporamaAdministration()
	{
		if(jeSuisAdmin() || jeSuisRedacteur())
		{
			$listeDiaposActives = $listeDiaposInactives = '';
			require('fonctionBdd.php');
			$requete ='SELECT * FROM `slideshow` WHERE `sliAffiche` = 1';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				if($row->sliLocal) { $nomDomaine= 'Serveur local'; }
				else
				{
					$nomDomaine = parse_url($row->sliUrl);
					$nomDomaine = $nomDomaine['host'];
				}
				$listeDiaposActives .= '<tr>
											<td>'.$row->sliId.'</td>
											<td><a href="'.(($row->sliLocal)?'diaporama/'.$row->sliUrl:$row->sliUrl).'" target="_blank" title="Ouvrir l\'image dans un nouvel onglet">'.$row->sliTitre.'</a></td>
											<td>'.$nomDomaine.'</td>
											<td><img class="desactiverDiapo" data-id="'.$row->sliId.'" src="img/thumbs_down.png" alt="Désactiver l\'image" title="Desactiver cette image"/></td>
											<td><img class="supprimerDiapo" data-id="'.$row->sliId.'" src="img/remove_2.png" alt="Supprimer l\'image" title="Supprimer cette image"/></td>
										</tr>';
			}
			
			$requete ='SELECT * FROM `slideshow` WHERE `sliAffiche` = 0';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				if($row->sliLocal) { $nomDomaine= 'Serveur local'; }
				else
				{
					$nomDomaine = parse_url($row->sliUrl);
					$nomDomaine = $nomDomaine['host'];
				}
				$listeDiaposInactives .= '<tr>
											<td>'.$row->sliId.'</td>
											<td><a href="'.(($row->sliLocal)?'diaporama/'.$row->sliUrl:$row->sliUrl).'" target="_blank" title="Ouvrir l\'image dans un nouvel onglet">'.$row->sliTitre.'</a></td>
											<td>'.$nomDomaine.'</td>
											<td><img class="activerDiapo" data-id="'.$row->sliId.'" src="img/thumbs_up.png" alt="Désactiver l\'image" title="Desactiver cette image"/></td>
											<td><img class="supprimerDiapo" data-id="'.$row->sliId.'" src="img/remove_2.png" alt="Supprimer l\'image" title="Supprimer cette image"/></td>
										</tr>';
			}
					
			$diapoAdministration = '<table>
				<tr>
					<td>'. formulaireDiapoAdministration('local') .'</td>
					<td>'. formulaireDiapoAdministration('distant') .'</td>
				</tr>
			</table>
			<fieldset>
				<legend><h4>Liste des diapositives actives</h4></legend>
				<table id="listeDiaposActives">
					<tr>
						<th>ID</th><th>Titre</th><th>Serveur</th><th>Désactiver</th><th>Supprimer</th>
					</tr>
					'.$listeDiaposActives.'
				</table>
			</fieldset>
			<fieldset>
				<legend><h4>Liste des diapositives inactives</h4></legend>
				<table id="listeDiaposInactives">
					<tr>
						<th>ID</th><th>Titre</th><th>Url</th><th>Serveur</th><th>Activer</th><th>Supprimer</th>
					</tr>
					'.$listeDiaposInactives.'
				</table>
			</fieldset>
			<script src="js/diapoAjax.js"></script>';
			
			$resultat = '<fieldset class="zoneAdministration">
							<legend><h2>Gestion du diaporama</h2></legend>
							<p class="detail">Vos images doivent doivent respecter le ratio l/h = 2.36 et et mesurer au moins 680 pixels de largeur et 288px de hauteurs.<br />
							Le cas échéant, elles apparaîtront déformées.
							</p>
							<span class="contenuDiapoAdministration">'.$diapoAdministration.'</span>
						</fieldset>';
		}
		else
		{
			$resultat = 'Vous ne disposez pas de droits suffisants pour acceder à cette  partie du site.<a id="pagePrecedente"></a>
			<a href="index.php">Retourner sur la page d\'accueil</a>';
		}
		
		echo menuAdministration().$resultat;
	}
	
	function formulaireDiapoAdministration($mode='local')
	{
		if(jeSuisRedacteur() || jeSuisAdmin())
		{
			$mode = ($mode != 'local' && $mode != 'distant')?'local':$mode;
			$fomulaireLocal = '<fieldset>
							<legend><h4>Ajouter une diapo au serveur local</h4></legend>
							<form method="POST" action="?moteur=formulaire&objet=diaporama" enctype="multipart/form-data">
								<input type="hidden" name="ajout" value="local" />
								<table>
									<tr>
										<td>Titre</td><td><input type="text" name="titre" /></td>
									</tr>
									<tr>
										<td>Fichier</td><td><input type="file" name="fichier" /></td>
									</tr>
									<tr>
										<td>En tant que</td>
										<td>
											<select name="affiche">
												<option value="1">Diapo active</option>
												<option value="0">Diapo inactive</option>
											</select>
											<input type="submit" value="Ajouter l\'image" />
										</td>
									</tr>
								</table>
							</form>
						</fieldset>';
			$formulaireDistant = '<fieldset>
						<legend><h4>Ajouter une diapodepuis un serveur distant</h4></legend>
						<form method="POST" action="?moteur=formulaire&objet=diaporama">
							<input type="hidden" name="ajout" value="distant" />
							<table>
								<tr>
									<td>Titre</td><td><input type="text" name="titre" /></td>
								</tr>
								<tr>
									<td>URL</td><td><input type="text" name="url" /></td>
								</tr>
								<tr>
									<td>En tant que</td>
									<td>
										<select name="affiche">
											<option value="1">Diapo active</option>
											<option value="0">Diapo inactive</option>
										</select>										
										<input type="submit" value="Ajouter l\'image" />
									</td>
								</tr>
							</table>
						</form>
					</fieldset>';
			$resultat = ($mode == 'local')?$fomulaireLocal:$formulaireDistant;
		}
		else
		{
			$resultat = 'Vous ne disposez pas de droits suffisants pour afficher le fomulaire d\'ajout de diapositive';
		}
		return $resultat;
	}
	
	function mediathequeAdministration($dossier)
	{
		$selecteurDossier = '<h3>Choisir dossier</h3>
			<a href="?moteur=administration&objet=mediatheque">Tout les dossiers</a>
			<a href="?moteur=administration&objet=mediatheque;photo">Photos</a>
			<a href="?moteur=administration&objet=mediatheque;video">Vidéos</a>
			<a href="?moteur=administration&objet=mediatheque;audio">audio</a>
			<a href="?moteur=administration&objet=mediatheque;document">Document</a>
		<hr />';
		switch($dossier)
		{
			case 'photo':
			$resultat = (function_exists('photoMediatheque'))? photoMediatheque('administration'):'<p>Gestionnaire photo introuvable</>';
			break;
			case 'video':
			$resultat = (function_exists('videoMediatheque'))? videoMediatheque('administration'):'<p>Gestionnaire video introuvable</>';
			break;
			case 'audio':
			$resultat =(function_exists('audioMediatheque'))? audioMediatheque('administration'):'<p>Gestionnaire audio introuvable</>';
			break;
			case 'document':
			$resultat = (function_exists('documentMediatheque'))? documentMediatheque('administration'):'<p>Gestionnaire de document introuvable</>';
			break;
			default :
			$resultat = (function_exists('photoMediatheque'))? photoMediatheque('administration'):'<p>Gestionnaire photo introuvable</>';
			$resultat .= (function_exists('videoMediatheque'))? videoMediatheque('administration'):'<p>Gestionnaire video introuvable</>';
			$resultat .= (function_exists('audioMediatheque'))? audioMediatheque('administration'):'<p>Gestionnaire audio introuvable</>';
			$resultat .= (function_exists('documentMediatheque'))? documentMediatheque('administration'):'<p>Gestionnaire de document introuvable</>';
			break;
		}
		
		
		echo menuAdministration().'<fieldset class="zoneAdministration"><legend><h2>Médiathèque</h2></legend>'.$selecteurDossier.$resultat.'</fieldset>';
	}
	
	function themeAdministration($id="tous")
	{
		if(jeFaisPartieDuStaff())
		{
			require('fonctionBdd.php');
			$requete = 'SELECT * FROM `themes` WHERE `theActivite` = 1 LIMIT 1';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			if($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$themeActif = '<tr><td>'.$row->theId.'</td><td>'.$row->theNom.'</td><td>'.$row->theDossier.'</td><td  class="detail">'.$row->theInformations.'</td></tr>';
			}
			else
			{
				$themeActif = '<tr><td colspan="4">Aucun thème n\'est activé sur le site.</td></tr>';
			}
			
			$requete = 'SELECT * FROM `themes`';
			$stmt = $bdd->prepare($requete);
			$stmt->execute();
			$themeEnregistre = array();
			while($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$themeEnregistre[] = '<tr>
										<td>'.$row->theId.'</td>
										<td>'.$row->theNom.'</td>
										<td>'.$row->theDossier.'</td>
										<td class="detail">'.$row->theInformations.'</td>
										<td><a href="?moteur=index&theme='.$row->theDossier.'" target="_blank"><img src="img/eye_open.png" alt="Prévisualiser" title="Voir à quoi ressemble le thème '.$row->theNom.'"/></a></td>
										<td><img class="activerTheme" src="img/thumbs_up.png" alt="Activer" title="Utiliser le thème '.$row->theNom.' sur le site web" data-id="'.$row->theId.'" data-nom="'.$row->theNom.'"/></td>
										<td><img class="exporterTheme" src="img/disk_export.png" alt="Exporter" title="Exporter le thème '.$row->theNom.' sur mon ordinateur" data-id="'.$row->theId.'" data-nom="'.$row->theNom.'"/></td>
										<td><img class="supprimerTheme" src="img/remove_2.png" alt="Supprimer" title="Supprimer le thème '.$row->theNom.'" data-id="'.$row->theId.'" data-nom="'.$row->theNom.'"/></td>
									</tr>';
			}
			$aucunEnregistrement = array('<tr><td colspan="4">Aucun thème n\'est enrégistré sur le site.</td></tr>');
			$themeEnregistre = (count($themeEnregistre) < 1)?$aucunEnregistrement:$themeEnregistre;
			$resultat = '<fieldset>
							<legend><h4>Ajouter un nouveau thème</h4></legend>
							<form method="POST" action="?moteur=formulaire&objet=ajouterTheme" enctype="multipart/form-data">
								<input type="file" name="theme" /><input type="submit" vaue="Ajouter ce thème" />
							</form>
						</fieldset>
						<fieldset>
						<legend><h4>Thème en cours d\'utilisation</h4></legend>
						<table class="detail">
							<tr>
								<th>ID</th>
								<th>Nom</th>
								<th>Répertoire</th>
								<th>Informations</th>
							</tr>
							'.$themeActif.'
						</table>
					</fieldset>
					<fieldset>
						<legend><h4>Liste des thèmes enregistrés</h4></legend>
						<table  class="detail">
							<tr>
								<th>ID</th>
								<th>Nom</th>
								<th>Répertoire</th>
								<th>Informations</th>
								<th>Prévisualiser</th>
								<th>Activer</th>
								<th>Exporter</th>
							</tr>
							'. implode('',$themeEnregistre).'
						</table>
					</fieldset>';
		}
		else
		{
			$resultat = 'Vous ne disposez pas de suffisament de droits pour consulter cette partie du site.
			<a id="pagePrecedente"></a>';
		}
	
	
		echo menuAdministration().'
			<fieldset  class="zoneAdministration">
				<legend><h2>Gérer le thème</h2></legend>
				'.$resultat.'
			</fieldset>
			<script src="js/administrationThemeAjax.js"></script>';
		
	}
	
	function aproposAdministration($id="")
	{
		$resultat = '<fieldset class="zoneAdministration">'.aProposDeCalypso().'
		</fieldset>';
		echo menuAdministration().$resultat;
	}
	
	function architectureAdministration()
	{
		if(jeSuisRedacteur() || jeSuisAdmin())
		{
			$requete = array(
			"listeArticle" => 'SELECT * FROM `articles` WHERE `artValide` = 1 ORDER BY `artTitre`',
			"rubriquesEpinglees" => 'SELECT * FROM `rubriques` WHERE `rubEpingle` = 1',
			"rubriquesNonEpinglees" => 'SELECT * FROM `rubriques` WHERE `rubEpingle` = 0');
			$listeArticles = $listeRubriquesNonEpinglees = $listeRubriquesEpinglees = '';
			
			require('fonctionBdd.php');
			
			$stmt = $bdd->prepare($requete['listeArticle']);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$selected = ($row->artEpingle)?'selected="selected"':'';
				$listeArticles .= '<option value="'.$row->artId.'" '.$selected.'>'.$row->artTitre.'</option>';
			}
			
			$stmt = $bdd->prepare($requete['rubriquesEpinglees']);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$listeRubriquesEpinglees .= '<tr><td>'.$row->rubId.'</td><td>'.$row->rubNom.'</td>
										<td><img class="desepinglerRubrique" src="img/remove_2.png" data-id="'.$row->rubId.'" data-nom="'.$row->rubNom.'" alt="Ôter" title="Ôter l\'épingle de la rubrique '.$row->rubNom.'"/></td>
									</tr>';
			}
			$listeRubriquesEpinglees = ($listeRubriquesEpinglees == '')?'<td colspan="3"><i>Aucune rubrique n\'est acutuellement épinglée</i></td>':$listeRubriquesEpinglees;
			
			$stmt = $bdd->prepare($requete['rubriquesNonEpinglees']);
			$stmt->execute();
			while($row = $stmt->fetch(PDO::FETCH_OBJ))
			{
				$listeRubriquesNonEpinglees .= '<tr><td>'.$row->rubId.'</td><td>'.$row->rubNom.'</td>
										<td><img class="epinglerRubrique" src="img/pushpin.png" data-id="'.$row->rubId.'" data-nom="'.$row->rubNom.'" alt="Ôter" title="Ôter l\'épingle de la rubrique '.$row->rubNom.'"/></td>
									</tr>';
			}
			
			$listeRubriquesNonEpinglees = ($listeRubriquesNonEpinglees == '')?'<td colspan="3"><i>Toutes vos rubriques sont acutuellement épinglées</i></td>':$listeRubriquesNonEpinglees;
			
			$resultat ='<fieldset>
					<legend><h4>Article épinglé</h4></legend>
					<table>
						<tr>
							<td>
								<p>
									Ci-à-droite, vous pouvez choisir d\'épingler un article sur la page d\'accueil du site.<br />
									Cet article sera tout le temps affiché sur la page d\'accueil sous forme de breve.<br />
								</p>
							</td>
							<td>
								<form method="POST" action="?moteur=formulaire&objet=epinglerArticle">
									<select name="id">
									<option value="aucun">Pas d\'article épinglé</option>
									'.$listeArticles.'
									</select>
									<input type="submit" value="Valider ce choix"/>
								</form>
								<p class="detail">
									Notez que seuls les articles approuvés par les administrateurs peuvent être lus par les visiteurs. Pensez donc à retiré un article épinglé s\'il passe en désaprobation.
								</p>
							</td>
						</tr>
					</table>
				</fieldset>
				<fieldset>
					<legend><h4>Liste des rubriques épinglées</h4></legend>
					<table>
						<tr>
							<td>
								<table>
									<tr><th>Id</th><th>Nom</th><th>Ôter l\'épingle</th></tr>
									'.$listeRubriquesEpinglees.'
								</table>
							</td>
							<td class="detail" style="vertical-align:top;">
								<p>
									A l\'instar des articles, les rubriques peuvent aussi être épinglées.<br />
									Leur dernier contenu apparaitra sous forme de brève en dessous de la Une et de l\'article épinglé.<br />
								</p>
							</td>
						</tr>
					</table>
				</fieldset>
				<fieldset>
					<legend><h4>Liste des rubriques non épinglées</h4></legend>
					<table>
						<tr>
							<td>
								<table>
									<tr><th>Id</th><th>Nom</th><th>Ajouter l\'épingle</th></tr>
									'.$listeRubriquesNonEpinglees.'
								</table>
							</td>
							<td class="detail" style="vertical-align:top;">
								<p>
									Ci-à-gauche la liste des rubriques sans épingle.
								</p>
							</td>
						</tr>
					</table>
					
				</fieldset>';
		}
		else
		{
			$resultat = 'Vous ne disposez pas de suffisament de droits pour consulter cette partie du site.
			<a id="pagePrecedente"></a>
			<a href="?moteur=administration&objet=index">Revenir sur l\'administration du site</a>';
		}
		echo menuAdministration().'<fieldset class="zoneAdministration">
			<legend><h2>Architecture de la page d\'accueil</h2></legend>
				'.$resultat.'
			</fieldset>
			<script src="js/administrationArchitecture.js"></script>';
	}
?>