$(document).ready(function()
{

	var slideIterator = 1;
	slideIterator =	afficherSlide(slideIterator);
	function afficherSlide(i)
	{
		$('#slideshow .slide').fadeOut(2000);
		$('*[data-slide="'+i+'"]').fadeIn(1800);
		return (i >= $('#slideshow .slide').length)? 1: (i+1);
	}
	var jouerSlide = setInterval( function() { slideIterator = afficherSlide(slideIterator); } , 10000);
	$('.uneDynamique .une').each(function(i){
		$(this).attr('data-iterator',(i+1));
		var boutonPrecedent = '<img src="img/precedent.png" class="indicePrecedent" data-cible="'+i+'" />';
		var boutonSuivant = '<img src="img/suivant.png" class="indiceSuivant" data-cible="'+(i+2)+'"/>';
		var indiceActuel = '<span class="indiceActuel">'+(i+1)+'</span>';
		var boutonsUneDynamique = '<span class="boutonsUneDynamique">'+boutonPrecedent+' '+indiceActuel+' '+boutonSuivant+'</span>';
		$(boutonsUneDynamique).prependTo(this);
	});
	var uneDynamiqueIterator = 1;
	uneDynamiqueIterator = uneDynamique(uneDynamiqueIterator);
	function uneDynamique(i)
	{
		$('.uneDynamique .une').fadeOut(1500);
		$('*[data-iterator="'+i+'"]').fadeIn(1000);
		return ((i) >= $('.uneDynamique .une').length)? 1: (i+1);
	}
	var jouerUneDynamique = setInterval( function() { uneDynamiqueIterator = uneDynamique(uneDynamiqueIterator); } , 10000);
	$('.indicePrecedent').click(function(){
		clearInterval(jouerUneDynamique);
		uneDynamiqueCible = Math.max(1,$(this).data('cible'))
		uneDynamiqueIterator = uneDynamique(uneDynamiqueCible);
		jouerUneDynamique = setInterval( function() { uneDynamiqueIterator = uneDynamique(uneDynamiqueIterator); } , 10000);
	});
	$('.indiceSuivant').click(function(){
		clearInterval(jouerUneDynamique);
		uneDynamiqueCible = Math.min($(this).data('cible'), $('.uneDynamique .une').length);
		uneDynamiqueIterator = uneDynamique(uneDynamiqueCible);
		jouerUneDynamique = setInterval( function() { uneDynamiqueIterator = uneDynamique(uneDynamiqueIterator); } , 10000);
	});
	$('#cryptogrammeNewsletter').fadeOut(200);
	$('#newsletterFormulaire select#actionNewsletter').change(function(){
		if($(this).val() == 'abonnement') { $('#cryptogrammeNewsletter').fadeOut(); }
		else { $('#cryptogrammeNewsletter').fadeIn(); }
	});
	$('#pagePrecedente').text('Retour en arrière');
	$('#pagePrecedente').click(function(e){
        e.preventDefault();
        history.back();
    });
	
	$('#creerUtilisateur input[type="submit"]').prop("disabled", true);
	$('#creerUtilisateur input[name="nom"]').keyup(function(){
		if($(this).val().length < 4) { $('.notifNom').html('Le nom doit contenir au moins 4 caractères'); }
		else if($(this).val().length > 10) { $('.notifNom').html('Le nom doit contenir 10 caractères maximum'); }
		else { $('.notifNom').html('Le champ est correctement rempli.'); }
		activerSubmitCreationUtilisateur();
	});
	$('#creerUtilisateur input[name="prenom"]').keyup(function(){
		if($(this).val().length < 4) { $('.notifPrenom').html('Le prénom doit contenir au moins 4 caractères'); }
		else if($(this).val().length > 10) { $('.notifPrenom').html('Le prénom doit contenir 10 caractères maximum'); }
		else {$('.notifPrenom').html('Le champ est correctement rempli.');}
		activerSubmitCreationUtilisateur();
	});
	$('#creerUtilisateur input[name="email"]').keyup(function()
	{
		var email = $(this).val();
		$.ajax({ "url": 'php/verifierEmail.php?email='+email}).done(function( html )
		{
			$('.notifEmail').html(html);
		});
		activerSubmitCreationUtilisateur();
	});
	
	
	function nl2br(str, is_xhtml)
	{   
		var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';    
		return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1'+ breakTag +'$2');
	}
	function maintenant()
	{
		var t = new Date(); var jour = t.getDate(); var mois = t.getMonth()+1; var annee = t.getFullYear();
		return jour+'/'+mois+'/'+annee;
	}
	function activerSubmitCreationUtilisateur()
	{
		var succes = 'Le champ est correctement rempli.';
		var nom = ($('.notifNom').text() == succes)?true:false;
		var prenom = ($('.notifPrenom').text() == succes)?true:false;
		var email = ($('.notifEmail').text() == succes)?true:false;
		if(nom && prenom && email) { $('#creerUtilisateur input[type="submit"]').prop("disabled", false); }
		else { $('#creerUtilisateur input[type="submit"]').prop("disabled", true);}
		console.log(nom+' '+prenom+' '+email)
	}
	
});

function notifier(message)
{
	notif = $("#notification");
	notif.html(message);
	
	notif.animate({ opacity: 1, right: "0px"}, 300, function()
	{
		notif.focus(function(){
			notif.stop(true, true);
			notif.animate({ opacity: 1, right: "0px"}, 100);
			console.log('animation stopped');
		});
		notif.mouseout(function(){
			notif.delay(2500).animate({ opacity: 0, right: "-310px" }, 300, function(){notif.html('');});
		});
	});
}
